/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.collect.MapMaker;
import dan200.computercraft.shared.common.TileGeneric;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Set<BlockEntity> toTick = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());

    private TickScheduler() {
    }

    public static void schedule(TileGeneric tile) {
        Level world = tile.m_58904_();
        if (world != null && !world.f_46443_) {
            toTick.add(tile);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Iterator<BlockEntity> iterator = toTick.iterator();
        while (iterator.hasNext()) {
            BlockEntity tile = iterator.next();
            iterator.remove();
            Level world = tile.m_58904_();
            BlockPos pos = tile.m_58899_();
            if (world == null || pos == null || !world.m_46749_(pos) || world.m_7702_(pos) != tile) continue;
            world.m_186460_(pos, tile.m_58900_().m_60734_(), 0);
        }
    }
}

