/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.api.common.data;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class MachineReference
implements INBTSerializable<CompoundTag> {
    public GlobalBlockPos globalPos;
    public ResourceLocation registryName;
    public boolean chunkLoaded;
    public Direction insertFacing = Direction.UP;
    public Direction extractFacing = Direction.DOWN;
    public String customName = null;
    protected ItemStack cachedItemStack = ItemStack.f_41583_;
    protected Item cachedItem = null;
    protected Block cachedBlock = null;

    public MachineReference() {
    }

    public MachineReference(BlockPos pos, ResourceKey<Level> dimensionKey, ResourceLocation registryName, boolean chunkLoaded) {
        this(new GlobalBlockPos(pos, dimensionKey), registryName, chunkLoaded);
    }

    public MachineReference(GlobalBlockPos globalPos, ResourceLocation registryName, boolean chunkLoaded) {
        this.globalPos = globalPos;
        this.registryName = registryName;
        this.chunkLoaded = chunkLoaded;
    }

    public static MachineReference from(BlockEntity blockEntity) {
        GlobalBlockPos pos = GlobalBlockPos.from(blockEntity);
        BlockState state = blockEntity.m_58904_().m_8055_(pos.getPos());
        ItemStack item = state.m_60734_().m_7397_((BlockGetter)blockEntity.m_58904_(), pos.getPos(), state);
        boolean isLoaded = blockEntity.m_58904_().m_46749_(pos.getPos());
        return new MachineReference(pos, item.m_41720_().getRegistryName(), isLoaded);
    }

    public static MachineReference from(CompoundTag compound) {
        MachineReference reference = new MachineReference();
        reference.deserializeNBT(compound);
        return reference;
    }

    public static MachineReference from(FriendlyByteBuf buf) {
        MachineReference reference = new MachineReference();
        reference.decode(buf);
        return reference;
    }

    public Block getBlock() {
        if (this.cachedBlock == null) {
            this.cachedBlock = (Block)ForgeRegistries.BLOCKS.getValue(this.registryName);
        }
        return this.cachedBlock;
    }

    public Item getItem() {
        if (this.cachedItem == null) {
            this.cachedItem = (Item)ForgeRegistries.ITEMS.getValue(this.registryName);
        }
        return this.cachedItem;
    }

    public ItemStack getItemStack() {
        if (this.cachedItemStack.m_41619_()) {
            this.cachedItemStack = new ItemStack((ItemLike)this.getItem());
        }
        return this.cachedItemStack;
    }

    public CompoundTag serializeNBT() {
        return this.write(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.read(nbt);
    }

    public CompoundTag write(CompoundTag compound) {
        if (this.globalPos != null) {
            compound.m_128365_("globalPos", (Tag)this.globalPos.serializeNBT());
        }
        if (this.registryName != null) {
            compound.m_128359_("registryName", this.registryName.toString());
        }
        if (!StringUtils.isBlank((CharSequence)this.customName)) {
            compound.m_128359_("customName", this.customName);
        }
        compound.m_128379_("isChunkLoaded", this.chunkLoaded);
        compound.m_128344_("insertFacing", (byte)this.insertFacing.m_122411_());
        compound.m_128344_("extractFacing", (byte)this.extractFacing.m_122411_());
        return compound;
    }

    public void read(CompoundTag compound) {
        if (compound.m_128441_("globalPos")) {
            this.globalPos = GlobalBlockPos.from(compound.m_128469_("globalPos"));
        }
        if (compound.m_128441_("registryName")) {
            this.registryName = new ResourceLocation(compound.m_128461_("registryName"));
        }
        if (compound.m_128441_("customName")) {
            this.customName = compound.m_128461_("customName");
        }
        this.chunkLoaded = compound.m_128471_("isChunkLoaded");
        this.insertFacing = Direction.m_122376_((int)compound.m_128451_("insertFacing"));
        this.extractFacing = Direction.m_122376_((int)compound.m_128451_("extractFacing"));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.write(new CompoundTag()));
    }

    public void decode(FriendlyByteBuf buf) {
        this.deserializeNBT(buf.m_130260_());
    }

    public BlockEntity getBlockEntity(Level level) {
        return BlockEntityUtil.get(level, this.globalPos);
    }
}

