/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.github.klikli_dev.occultism.api.client.gui.IStorageControllerGuiContainer;
import com.github.klikli_dev.occultism.util.RenderUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ItemSlotWidget {
    protected int x;
    protected int y;
    protected int stackSize;
    protected int guiLeft;
    protected int guiTop;
    protected boolean showStackSize;
    protected Minecraft minecraft;
    protected IStorageControllerGuiContainer parent;
    protected ItemStack stack;
    protected Font fontRenderer;
    protected int slotHighlightColor;

    public ItemSlotWidget(IStorageControllerGuiContainer parent, @Nonnull ItemStack stack, int x, int y, int stackSize, int guiLeft, int guiTop, boolean showStackSize) {
        this.x = x;
        this.y = y;
        this.stackSize = stackSize;
        this.guiLeft = guiLeft;
        this.guiTop = guiTop;
        this.showStackSize = showStackSize;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.stack = stack;
        this.fontRenderer = this.parent.getFontRenderer();
        this.slotHighlightColor = new Color(255, 255, 255, 128).getRGB();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public boolean getShowStackSize() {
        return this.showStackSize;
    }

    public void setShowStackSize(boolean showStackSize) {
        this.showStackSize = showStackSize;
    }

    public boolean isMouseOverSlot(int mouseX, int mouseY) {
        return this.parent.isPointInRegionController(this.x - this.guiLeft, this.y - this.guiTop, 16, 16, mouseX, mouseY);
    }

    public void drawSlot(PoseStack poseStack, int mx, int my) {
        poseStack.m_85836_();
        if (!this.getStack().m_41619_()) {
            if (this.showStackSize) {
                String amount = Screen.m_96638_() ? Integer.toString(this.stackSize) : TextUtil.formatLargeNumber(this.stackSize);
                poseStack.m_85836_();
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                this.minecraft.m_91291_().f_115093_ = 0.1f;
                RenderUtil.renderGuiItemDecorationsWithPose(this.minecraft.m_91291_(), this.fontRenderer, poseStack, this.stack, this.x * 2 + 16, this.y * 2 + 16, amount);
                poseStack.m_85849_();
            }
            this.minecraft.m_91291_().f_115093_ = -100.0f;
            this.minecraft.m_91291_().m_115203_(this.getStack(), this.x, this.y);
            if (this.isMouseOverSlot(mx, my)) {
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.parent.drawGradientRect(poseStack, this.x, this.y, this.x + 16, this.y + 16, this.slotHighlightColor, this.slotHighlightColor);
                RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        poseStack.m_85849_();
    }

    public void drawTooltip(PoseStack poseStack, int mx, int my) {
        if (this.isMouseOverSlot(mx, my) && !this.getStack().m_41619_()) {
            this.parent.renderToolTip(poseStack, this.getStack(), mx, my);
        }
    }
}

