/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.model.entity;

import com.github.klikli_dev.occultism.common.entity.BlacksmithFamiliarEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BlacksmithFamiliarModel
extends EntityModel<BlacksmithFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart wagon;
    public ModelPart rightArm;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart head;
    public ModelPart hammer1;
    public ModelPart hammer2;
    public ModelPart nose;
    public ModelPart mouth1;
    public ModelPart leftEar;
    public ModelPart hair1;
    public ModelPart rightEar;
    public ModelPart hair2;
    public ModelPart mouth2;
    public ModelPart christmasBeard;
    public ModelPart earring;
    public ModelPart anvil1;
    public ModelPart anvil2;
    public ModelPart anvil3;
    public ModelPart wheel1;
    public ModelPart wheel2;
    public ModelPart wheel3;
    public ModelPart wheel4;
    public ModelPart anvil4;
    public ModelPart anvil5;
    public ModelPart anvil6;
    public ModelPart anvil7;

    public BlacksmithFamiliarModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.wagon = part.m_171324_("wagon");
        this.rightArm = this.body.m_171324_("rightArm");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.head = this.body.m_171324_("head");
        this.hammer1 = this.rightArm.m_171324_("hammer1");
        this.hammer2 = this.hammer1.m_171324_("hammer2");
        this.nose = this.head.m_171324_("nose");
        this.mouth1 = this.head.m_171324_("mouth1");
        this.leftEar = this.head.m_171324_("leftEar");
        this.hair1 = this.head.m_171324_("hair1");
        this.rightEar = this.head.m_171324_("rightEar");
        this.hair2 = this.head.m_171324_("hair2");
        this.mouth2 = this.head.m_171324_("mouth2");
        this.christmasBeard = this.head.m_171324_("christmasBeard");
        this.earring = this.leftEar.m_171324_("earring");
        this.anvil1 = this.wagon.m_171324_("anvil1");
        this.anvil2 = this.wagon.m_171324_("anvil2");
        this.anvil3 = this.wagon.m_171324_("anvil3");
        this.wheel1 = this.wagon.m_171324_("wheel1");
        this.wheel2 = this.wagon.m_171324_("wheel2");
        this.wheel3 = this.wagon.m_171324_("wheel3");
        this.wheel4 = this.wagon.m_171324_("wheel4");
        this.anvil4 = this.anvil3.m_171324_("anvil4");
        this.anvil5 = this.anvil4.m_171324_("anvil5");
        this.anvil6 = this.anvil4.m_171324_("anvil6");
        this.anvil7 = this.anvil4.m_171324_("anvil7");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition body = parts.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-2.5f, -5.0f, -1.5f, 5.0f, 5.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wagon = parts.m_171599_("wagon", CubeListBuilder.m_171558_().m_171514_(14, 12).m_171506_(-3.5f, 0.0f, -3.0f, 7.0f, 1.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)22.5f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171506_(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, true), PartPose.m_171423_((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171506_(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.m_171423_((float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171506_(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.m_171423_((float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(43, 2).m_171506_(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hammer1 = rightArm.m_171599_("hammer1", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171506_(-0.5f, -0.5f, -3.0f, 1.0f, 1.0f, 3.0f, true), PartPose.m_171423_((float)-1.0f, (float)5.0f, (float)0.0f, (float)0.625526f, (float)1.7983873f, (float)0.0f));
        PartDefinition hammer2 = hammer1.m_171599_("hammer2", CubeListBuilder.m_171558_().m_171514_(14, 6).m_171506_(-1.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(30, 7).m_171506_(-1.0f, 0.0f, -2.0f, 2.0f, 3.0f, 2.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.2f, (float)-1.5f, (float)-0.23457225f, (float)0.0f, (float)0.0f));
        PartDefinition mouth1 = head.m_171599_("mouth1", CubeListBuilder.m_171558_().m_171514_(8, 26).m_171506_(-3.5f, -2.0f, 0.0f, 7.0f, 5.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.1f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171506_(0.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, false), PartPose.m_171423_((float)2.4f, (float)-3.0f, (float)0.0f, (float)0.2268928f, (float)-0.87266463f, (float)-0.5235988f));
        PartDefinition hair1 = head.m_171599_("hair1", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171506_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171506_(-4.0f, -2.0f, 0.0f, 4.0f, 3.0f, 0.0f, true), PartPose.m_171423_((float)-2.4f, (float)-3.0f, (float)0.0f, (float)0.2268928f, (float)0.87266463f, (float)0.5235988f));
        PartDefinition hair2 = head.m_171599_("hair2", CubeListBuilder.m_171558_().m_171514_(42, 21).m_171506_(-2.0f, -5.0f, -2.0f, 4.0f, 5.0f, 6.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mouth2 = head.m_171599_("mouth2", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171506_(-3.5f, -2.0f, 0.0f, 7.0f, 5.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.1f, (float)-3.2f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition christmasBeard = head.m_171599_("christmasBeard", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171506_(-3.5f, -2.0f, 0.0f, 7.0f, 7.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-2.7f, (float)((float)(-Math.PI) / 90), (float)0.0f, (float)0.0f));
        PartDefinition earring = leftEar.m_171599_("earring", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171506_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 0.0f, false), PartPose.m_171423_((float)1.4f, (float)1.0f, (float)0.0f, (float)0.0f, (float)2.391799f, (float)0.0f));
        PartDefinition anvil1 = wagon.m_171599_("anvil1", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, true), PartPose.m_171423_((float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil2 = wagon.m_171599_("anvil2", CubeListBuilder.m_171558_().m_171514_(42, 12).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, false), PartPose.m_171423_((float)2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil3 = wagon.m_171599_("anvil3", CubeListBuilder.m_171558_().m_171514_(51, 15).m_171506_(-1.0f, -2.0f, -1.5f, 2.0f, 3.0f, 3.0f, false), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel1 = wagon.m_171599_("wheel1", CubeListBuilder.m_171558_().m_171514_(34, 14).m_171506_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)3.5f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel2 = wagon.m_171599_("wheel2", CubeListBuilder.m_171558_().m_171514_(34, 14).m_171506_(0.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel3 = wagon.m_171599_("wheel3", CubeListBuilder.m_171558_().m_171514_(34, 14).m_171506_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)-3.5f, (float)0.5f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wheel4 = wagon.m_171599_("wheel4", CubeListBuilder.m_171558_().m_171514_(34, 14).m_171506_(-1.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, true), PartPose.m_171423_((float)-3.5f, (float)0.5f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil4 = anvil3.m_171599_("anvil4", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171506_(-3.0f, -1.5f, -2.0f, 6.0f, 3.0f, 4.0f, false), PartPose.m_171423_((float)0.0f, (float)-3.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil5 = anvil4.m_171599_("anvil5", CubeListBuilder.m_171558_().m_171514_(36, 18).m_171506_(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 4.0f, false), PartPose.m_171423_((float)-4.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition anvil6 = anvil4.m_171599_("anvil6", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171506_(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)-0.51f, (float)0.5f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        PartDefinition anvil7 = anvil4.m_171599_("anvil7", CubeListBuilder.m_171558_().m_171514_(16, 19).m_171506_(0.0f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.m_171423_((float)2.5f, (float)-0.5f, (float)-0.5f, (float)0.0f, (float)-0.27366763f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        ImmutableList.of((Object)this.body, (Object)this.wagon).forEach(modelRenderer -> modelRenderer.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
    }

    public void setupAnim(BlacksmithFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.wheel1.f_104203_ = limbSwing;
        this.wheel2.f_104203_ = limbSwing;
        this.wheel3.f_104203_ = limbSwing;
        this.wheel4.f_104203_ = limbSwing;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f)) * limbSwingAmount * 0.6f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.6f;
        this.leftArm.f_104203_ = this.toRad(-30.0f) + Mth.m_14089_((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f;
        this.leftArm.f_104204_ = this.toRad(-15.0f);
        this.rightArm.f_104203_ = this.toRad(-75.0f);
        this.rightArm.f_104204_ = this.toRad(25.0f);
        this.hammer1.f_104204_ = 0.0f;
        this.hammer1.f_104205_ = this.toRad(90.0f);
        this.hammer1.f_104203_ = 0.0f;
        this.body.f_104204_ = 0.0f;
        this.body.f_104201_ = 19.0f;
        this.body.f_104203_ = 0.0f;
        this.body.f_104202_ = 3.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        if (entityIn.isPartying()) {
            this.head.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.8f)) * this.toRad(25.0f);
            this.head.f_104204_ = 0.0f;
            this.leftArm.f_104203_ = this.toRad(-90.0f) + Mth.m_14089_((float)(ageInTicks * 1.2f)) * this.toRad(25.0f);
            this.leftArm.f_104204_ = this.toRad(-5.0f);
            this.leftArm.f_104205_ = this.toRad(20.0f);
            this.rightArm.f_104203_ = this.toRad(-90.0f) + Mth.m_14089_((float)(ageInTicks * 1.2f + (float)Math.PI)) * this.toRad(25.0f);
            this.rightArm.f_104204_ = this.toRad(-5.0f);
            this.rightArm.f_104205_ = this.toRad(-20.0f);
        } else if (entityIn.isSitting()) {
            this.body.f_104204_ = this.toRad(180.0f);
            this.leftLeg.f_104203_ = this.toRad(-70.0f);
            this.rightLeg.f_104203_ = this.toRad(-70.0f);
            this.body.f_104201_ = 23.0f;
            this.body.f_104202_ = 4.0f;
            this.body.f_104203_ = this.toRad(-20.0f);
            this.head.f_104203_ = this.toRad(20.0f);
            this.head.f_104204_ = 0.0f;
            this.leftArm.f_104203_ = this.toRad(-10.0f);
            this.rightArm.f_104203_ = this.toRad(-10.0f);
        }
    }

    public void prepareMobModel(BlacksmithFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.showModels(entityIn);
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void showModels(BlacksmithFamiliarEntity entityIn) {
        boolean hasSquarehair = entityIn.hasSquareHair();
        boolean hasMarioMoustache = entityIn.hasMarioMoustache();
        this.earring.f_104207_ = entityIn.hasEarring();
        this.mouth1.f_104207_ = !hasMarioMoustache;
        this.mouth2.f_104207_ = hasMarioMoustache;
        this.hair1.f_104207_ = hasSquarehair;
        this.hair2.f_104207_ = !hasSquarehair;
    }
}

