/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.github.klikli_dev.occultism.client.render.entity.DragonRendering;
import com.github.klikli_dev.occultism.common.entity.DragonFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class DragonFamiliarRenderer
extends MobRenderer<DragonFamiliarEntity, DragonFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/dragon_familiar.png");

    public DragonFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new DragonFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_DRAGON)), 0.3f);
        this.m_115326_(new DragonRendering.StickLayer((RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel>)this));
        this.m_115326_(new DragonRendering.SwordLayer((RenderLayerParent<DragonFamiliarEntity, DragonFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(DragonFamiliarEntity entity) {
        return TEXTURES;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="occultism", value={Dist.CLIENT})
    private static class RenderText {
        private RenderText() {
        }

        @SubscribeEvent
        public static void renderText(RenderLivingEvent<DragonFamiliarEntity, DragonFamiliarModel> event) {
            if (!(event.getEntity() instanceof DragonFamiliarEntity)) {
                return;
            }
            DragonFamiliarEntity dragon = (DragonFamiliarEntity)event.getEntity();
            float partialTicks = event.getPartialTick();
            float textTimer = (float)dragon.getPetTimer() + partialTicks;
            if (textTimer >= 40.0f) {
                return;
            }
            float height = dragon.m_20206_() + 0.5f;
            TranslatableComponent text = new TranslatableComponent("dialog.occultism.dragon.pet");
            PoseStack matrixStackIn = event.getPoseStack();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.0, (double)(height + textTimer / 20.0f), 0.0);
            matrixStackIn.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
            matrixStackIn.m_85837_((double)Mth.m_14031_((float)(textTimer / 2.0f)) * 0.5, 0.0, 0.0);
            float size = (1.0f - textTimer / 40.0f) * 0.025f;
            matrixStackIn.m_85841_(-size, -size, size);
            Matrix4f matrix = matrixStackIn.m_85850_().m_85861_();
            Font font = event.getRenderer().m_114481_();
            font.m_92841_((Component)text, (float)(-font.m_92852_((FormattedText)text)) / 2.0f, 0.0f, 0xFFFFFF, false, matrix, event.getMultiBufferSource(), false, 0, event.getPackedLight());
            matrixStackIn.m_85849_();
        }
    }
}

