/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.block;

import com.github.klikli_dev.occultism.crafting.recipe.ItemStackFakeInventory;
import com.github.klikli_dev.occultism.crafting.recipe.SpiritFireRecipe;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import com.github.klikli_dev.occultism.registry.OccultismSounds;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpiritFireBlock
extends Block {
    public SpiritFireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(0)));
    }

    private static int getTickCooldown(Random rand) {
        return 30 + rand.nextInt(10);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) ? (BlockState)this.m_49966_().m_61124_((Property)FireBlock.f_53408_, (Comparable)((Integer)pState.m_61143_((Property)FireBlock.f_53408_))) : Blocks.f_50016_.m_49966_();
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_()) {
            if (!state.m_60710_((LevelReader)worldIn, pos)) {
                worldIn.m_7471_(pos, false);
            } else {
                worldIn.m_186460_(pos, (Block)this, SpiritFireBlock.getTickCooldown(worldIn.f_46441_));
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((BlockGetter)worldIn, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        worldIn.m_186460_(pos, (Block)this, SpiritFireBlock.getTickCooldown(worldIn.f_46441_));
        if (!worldIn.isAreaLoaded(pos, 2)) {
            return;
        }
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_7471_(pos, false);
        }
        if (!worldIn.f_46443_) {
            this.convertItems((Level)worldIn, pos, state);
        }
        Block block = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        BlockState other = worldIn.m_8055_(pos.m_7495_());
        boolean isOnFireSource = other.isFireSource((LevelReader)worldIn, pos.m_7495_(), Direction.UP);
        int i = (Integer)state.m_61143_((Property)FireBlock.f_53408_);
        if (!isOnFireSource && worldIn.m_46471_() && this.canDie((Level)worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
            worldIn.m_7471_(pos, false);
        } else {
            int j = Math.min(15, i + rand.nextInt(3) / 2);
            if (i != j) {
                state = (BlockState)state.m_61124_((Property)FireBlock.f_53408_, (Comparable)Integer.valueOf(j));
                worldIn.m_7731_(pos, state, 4);
            }
            if (!isOnFireSource) {
                worldIn.m_186460_(pos, (Block)this, SpiritFireBlock.getTickCooldown(worldIn.f_46441_));
                if (!this.areNeighborsFlammable((BlockGetter)worldIn, pos)) {
                    BlockPos blockpos = pos.m_7495_();
                    if (!worldIn.m_8055_(blockpos).m_60783_((BlockGetter)worldIn, blockpos, Direction.UP) || i > 3) {
                        worldIn.m_7471_(pos, false);
                    }
                    return;
                }
                if (i == 15 && rand.nextInt(4) == 0 && !this.canCatchFire((BlockGetter)worldIn, pos.m_7495_(), Direction.UP)) {
                    worldIn.m_7471_(pos, false);
                    return;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                BlockPos blockpos = pos.m_7495_();
                BlockState blockstate = worldIn.m_8055_(blockpos);
                if (this.canCatchFire((BlockGetter)worldIn, blockpos, Direction.UP) || blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP)) break block11;
                if (this.canCatchFire((BlockGetter)worldIn, blockpos.m_142125_(), Direction.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pos.m_123341_() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)pos.m_123342_() + rand.nextDouble();
                        double d13 = (double)pos.m_123343_() + rand.nextDouble();
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d3, d8, d13, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((BlockGetter)worldIn, pos.m_142126_(), Direction.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pos.m_123341_() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)pos.m_123342_() + rand.nextDouble();
                        double d14 = (double)pos.m_123343_() + rand.nextDouble();
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d4, d9, d14, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((BlockGetter)worldIn, pos.m_142127_(), Direction.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pos.m_123341_() + rand.nextDouble();
                        double d10 = (double)pos.m_123342_() + rand.nextDouble();
                        double d15 = (double)pos.m_123343_() + rand.nextDouble() * (double)0.1f;
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d5, d10, d15, 0.0, 0.0, 0.0);
                    }
                }
                if (this.canCatchFire((BlockGetter)worldIn, pos.m_142128_(), Direction.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pos.m_123341_() + rand.nextDouble();
                        double d11 = (double)pos.m_123342_() + rand.nextDouble();
                        double d16 = (double)(pos.m_123343_() + 1) - rand.nextDouble() * (double)0.1f;
                        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d6, d11, d16, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.canCatchFire((BlockGetter)worldIn, pos.m_7494_(), Direction.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pos.m_123341_() + rand.nextDouble();
                    double d12 = (double)(pos.m_123342_() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)pos.m_123343_() + rand.nextDouble();
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d7, d12, d17, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.m_123341_() + rand.nextDouble();
                double d1 = (double)pos.m_123342_() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.m_123343_() + rand.nextDouble();
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123755_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FireBlock.f_53408_});
        super.m_7926_(builder);
    }

    public boolean canCatchFire(BlockGetter level, BlockPos pos, Direction face) {
        return level.m_8055_(pos).isFlammable(level, pos, face);
    }

    protected void convertItems(Level level, BlockPos pos, BlockState state) {
        Vec3 center = Math3DUtil.center(pos);
        AABB box = new AABB(-0.5, -0.5, -0.5, 0.5, 0.5, 0.5).m_82383_(center);
        List list = level.m_45976_(ItemEntity.class, box);
        ItemStackFakeInventory fakeInventory = new ItemStackFakeInventory(ItemStack.f_41583_);
        AtomicBoolean convertedAnyItem = new AtomicBoolean(false);
        list.stream().filter(Entity::m_6084_).forEach(item -> {
            fakeInventory.m_6836_(0, item.m_32055_());
            Optional recipe = level.m_7465_().m_44015_((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get(), (Container)fakeInventory, level);
            if (recipe.isPresent()) {
                convertedAnyItem.set(true);
                item.m_142687_(Entity.RemovalReason.DISCARDED);
                ItemStack result = ((SpiritFireRecipe)recipe.get()).assemble(fakeInventory);
                Containers.m_18992_((Level)level, (double)center.f_82479_, (double)(center.f_82480_ + 0.5), (double)center.f_82481_, (ItemStack)result);
            }
        });
        if (convertedAnyItem.get()) {
            level.m_5594_(null, pos, (SoundEvent)OccultismSounds.START_RITUAL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected boolean canDie(Level worldIn, BlockPos pos) {
        return worldIn.m_46758_(pos) || worldIn.m_46758_(pos.m_142125_()) || worldIn.m_46758_(pos.m_142126_()) || worldIn.m_46758_(pos.m_142127_()) || worldIn.m_46758_(pos.m_142128_());
    }

    private int getNeighborEncouragement(LevelReader worldIn, BlockPos pos) {
        if (!worldIn.m_46859_(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.m_8055_(pos.m_142300_(direction));
            i = Math.max(blockstate.getFlammability((BlockGetter)worldIn, pos.m_142300_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    private boolean areNeighborsFlammable(BlockGetter worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.m_142300_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }
}

