/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.blockentity;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.api.common.data.SortDirection;
import com.github.klikli_dev.occultism.api.common.data.SortType;
import com.github.klikli_dev.occultism.common.block.storage.StableWormholeBlock;
import com.github.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.registry.OccultismTiles;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class StableWormholeBlockEntity
extends NetworkedBlockEntity
implements IStorageControllerProxy,
MenuProvider,
IStorageAccessor {
    protected GlobalBlockPos linkedStorageControllerPosition;
    protected Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    protected ItemStack orderStack = ItemStack.f_41583_;
    protected SortDirection sortDirection = SortDirection.DOWN;
    protected SortType sortType = SortType.AMOUNT;

    public StableWormholeBlockEntity(BlockPos worldPos, BlockState state) {
        super((BlockEntityType)OccultismTiles.STABLE_WORMHOLE.get(), worldPos, state);
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack orderStack) {
        this.orderStack = orderStack;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        if (this.linkedStorageControllerPosition != null) {
            BlockEntity blockEntity = BlockEntityUtil.get(this.f_58857_, this.linkedStorageControllerPosition);
            if (blockEntity instanceof IStorageController) {
                IStorageController controller = (IStorageController)blockEntity;
                return controller;
            }
            if (!this.f_58857_.f_46443_) {
                this.linkedStorageControllerPosition = null;
                this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_(StableWormholeBlock.LINKED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
        return null;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        return this.linkedStorageControllerPosition;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
        this.linkedStorageControllerPosition = blockPos;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (this.getLinkedStorageController() != null) {
            return ((BlockEntity)this.getLinkedStorageController()).getCapability(cap, side);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void loadNetwork(CompoundTag compound) {
        if (compound.m_128441_("linkedStorageControllerPosition")) {
            this.linkedStorageControllerPosition = GlobalBlockPos.from(compound.m_128469_("linkedStorageControllerPosition"));
        }
        this.setSortDirection(SortDirection.get(compound.m_128451_("sortDirection")));
        this.setSortType(SortType.get(compound.m_128451_("sortType")));
        this.matrix = new HashMap<Integer, ItemStack>();
        if (compound.m_128441_("matrix")) {
            ListTag matrixNbt = compound.m_128437_("matrix", 10);
            for (int i = 0; i < matrixNbt.size(); ++i) {
                CompoundTag stackTag = matrixNbt.m_128728_(i);
                byte slot = stackTag.m_128445_("slot");
                ItemStack s = ItemStack.m_41712_((CompoundTag)stackTag);
                this.matrix.put(Integer.valueOf(slot), s);
            }
        }
        if (compound.m_128441_("orderStack")) {
            this.orderStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("orderStack"));
        }
        super.loadNetwork(compound);
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound) {
        if (this.linkedStorageControllerPosition != null) {
            compound.m_128365_("linkedStorageControllerPosition", (Tag)this.linkedStorageControllerPosition.serializeNBT());
        }
        compound.m_128405_("sortDirection", this.getSortDirection().getValue());
        compound.m_128405_("sortType", this.getSortType().getValue());
        ListTag matrixNbt = new ListTag();
        for (int i = 0; i < 9; ++i) {
            if (this.matrix.get(i) == null || this.matrix.get(i).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("slot", (byte)i);
            this.matrix.get(i).m_41739_(stackTag);
            matrixNbt.add((Object)stackTag);
        }
        compound.m_128365_("matrix", (Tag)matrixNbt);
        if (!this.orderStack.m_41619_()) {
            compound.m_128365_("orderStack", (Tag)this.orderStack.m_41739_(new CompoundTag()));
        }
        return super.saveNetwork(compound);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new StableWormholeContainer(id, playerInventory, this);
    }
}

