/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;

public class BlacksmithFamiliarEntity
extends FamiliarEntity {
    private static final ForgeConfigSpec.ConfigValue<Integer> UPGRADE_COST = Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarUpgradeCost;
    private static final EntityDataAccessor<Byte> BARS = SynchedEntityData.m_135353_(BlacksmithFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int ironCount;

    private static int getMaxIron() {
        return (Integer)UPGRADE_COST.get() * 10;
    }

    public BlacksmithFamiliarEntity(EntityType<? extends BlacksmithFamiliarEntity> type, Level level) {
        super(type, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setEarring(this.m_21187_().nextDouble() < 0.1);
        this.setMarioMoustache(this.m_21187_().nextDouble() < 0.5);
        this.setSquareHair(this.m_21187_().nextDouble() < 0.5);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new UpgradeGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        Item item = stack.m_41720_();
        if (playerIn == this.getFamiliarOwner() && this.ironCount < BlacksmithFamiliarEntity.getMaxIron() && (Tags.Items.INGOTS_IRON.m_8110_((Object)item) || Tags.Items.STORAGE_BLOCKS_IRON.m_8110_((Object)item))) {
            if (!this.f_19853_.f_46443_) {
                stack.m_41774_(1);
                this.changeIronCount(Tags.Items.INGOTS_IRON.m_8110_((Object)item) ? 1 : 9);
            }
            return InteractionResult.m_19078_((!this.f_19853_.f_46443_ ? 1 : 0) != 0);
        }
        return super.m_6071_(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasEarring()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BARS, (Object)0);
    }

    public boolean hasEarring() {
        return this.hasVariant(0);
    }

    public boolean hasMarioMoustache() {
        return this.hasVariant(1);
    }

    public boolean hasSquareHair() {
        return this.hasVariant(2);
    }

    private void setEarring(boolean b) {
        this.setVariant(0, b);
    }

    private void setMarioMoustache(boolean b) {
        this.setVariant(1, b);
    }

    private void setSquareHair(boolean b) {
        this.setVariant(2, b);
    }

    private void setIronCount(int count) {
        this.ironCount = count;
        this.f_19804_.m_135381_(BARS, (Object)((byte)Math.min(10, this.ironCount / (Integer)UPGRADE_COST.get())));
    }

    private void changeIronCount(int delta) {
        this.setIronCount(this.ironCount + delta);
    }

    public byte getBars() {
        return (Byte)this.f_19804_.m_135370_(BARS);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    protected void m_5907_() {
        int blockCount = this.ironCount / 9;
        int barCount = this.ironCount % 9;
        this.m_19983_(new ItemStack((ItemLike)Items.f_42416_, barCount));
        this.m_19983_(new ItemStack((ItemLike)Items.f_41913_, blockCount));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ironCount", this.ironCount);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setEarring(compound.m_128471_("hasEarring"));
            this.setMarioMoustache(compound.m_128471_("hasMarioMoustache"));
            this.setSquareHair(compound.m_128471_("hasSquareHair"));
        }
        this.setIronCount(compound.m_128451_("ironCount"));
    }

    private static class UpgradeGoal
    extends Goal {
        private static final ForgeConfigSpec.ConfigValue<Integer> MAX_COOLDOWN = Occultism.SERVER_CONFIG.spiritJobs.blacksmithFamiliarUpgradeCooldown;
        private final BlacksmithFamiliarEntity blacksmith;
        private IFamiliar target;
        private int cooldown = (Integer)MAX_COOLDOWN.get();

        public UpgradeGoal(BlacksmithFamiliarEntity blacksmith) {
            this.blacksmith = blacksmith;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.findTarget();
            return this.blacksmith.ironCount >= (Integer)UPGRADE_COST.get() && this.target != null && this.cooldown-- < 0;
        }

        public boolean m_8045_() {
            return this.target != null;
        }

        public void m_8056_() {
            this.blacksmith.m_21573_().m_5624_(this.target.getFamiliarEntity(), 0.7);
        }

        public void m_8041_() {
            this.blacksmith.m_21573_().m_26573_();
            this.cooldown = (Integer)MAX_COOLDOWN.get();
            this.target = null;
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            if (!this.blacksmith.m_21691_()) {
                this.blacksmith.m_21573_().m_5624_(this.target.getFamiliarEntity(), 0.7);
            }
            if (this.blacksmith.m_20280_(this.target.getFamiliarEntity()) < 3.0) {
                if (this.target.canBlacksmithUpgrade()) {
                    this.target.blacksmithUpgrade();
                    this.blacksmith.changeIronCount(-((Integer)UPGRADE_COST.get()).intValue());
                    OccultismAdvancements.FAMILIAR.trigger(this.blacksmith.getFamiliarOwner(), FamiliarTrigger.Type.BLACKSMITH_UPGRADE);
                }
                this.target = null;
            }
        }

        private IFamiliar findTarget() {
            Iterator iterator = this.blacksmith.f_19853_.m_6443_(LivingEntity.class, this.blacksmith.m_142469_().m_82400_(4.0), this::familiarPred).iterator();
            if (iterator.hasNext()) {
                LivingEntity e = (LivingEntity)iterator.next();
                return (IFamiliar)e;
            }
            return null;
        }

        private boolean familiarPred(Entity e) {
            if (!(e instanceof IFamiliar)) {
                return false;
            }
            IFamiliar familiar = (IFamiliar)e;
            LivingEntity owner = familiar.getFamiliarOwner();
            return familiar.canBlacksmithUpgrade() && owner != null && owner == this.blacksmith.getFamiliarOwner();
        }
    }
}

