/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.DevilFamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.google.common.collect.ImmutableList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class DeerFamiliarEntity
extends FamiliarEntity {
    private static final UUID SPEED_UUID = UUID.fromString("5ebf190f-3c59-41e7-9085-d14b37dfc863");
    private static final byte START_EATING = 10;
    private int eatTimer;
    private int neckRotTimer;
    private int oNeckRotTimer;

    public DeerFamiliarEntity(EntityType<? extends DeerFamiliarEntity> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new EatBlockGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && DeerFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasRedNose()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.m_146886_() && this.hasRedNose()) {
            this.m_146915_(true);
        }
        if (this.f_19853_.f_46443_) {
            --this.eatTimer;
            this.oNeckRotTimer = this.neckRotTimer;
            this.neckRotTimer = this.isEating() ? Math.min(this.neckRotTimer + 1, 10) : Math.max(this.neckRotTimer - 1, 0);
        }
        if (!this.f_19853_.f_46443_) {
            LivingEntity owner = this.getFamiliarOwner();
            if (owner != null && this.m_20280_((Entity)owner) > 50.0) {
                if (this.m_21051_(Attributes.f_22279_).m_22111_(SPEED_UUID) == null) {
                    this.m_21051_(Attributes.f_22279_).m_22118_(new AttributeModifier(SPEED_UUID, "deer_speedup", 0.15, AttributeModifier.Operation.ADDITION));
                }
            } else if (this.m_21051_(Attributes.f_22279_).m_22111_(SPEED_UUID) != null) {
                this.m_21051_(Attributes.f_22279_).m_22120_(SPEED_UUID);
            }
        }
    }

    public float getNeckRot(float partialTick) {
        return 0.4f + Mth.m_14179_((float)(Mth.m_14179_((float)partialTick, (float)this.oNeckRotTimer, (float)this.neckRotTimer) / 10.0f), (float)0.0f, (float)1.5f);
    }

    public void m_8035_() {
        if (this.m_21187_().nextDouble() < 0.25) {
            this.m_20000_((ItemLike)OccultismItems.DATURA_SEEDS.get(), 0);
            LivingEntity owner = this.getOwner();
            if (owner instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)owner;
                OccultismAdvancements.FAMILIAR.trigger(serverPlayer, FamiliarTrigger.Type.DEER_POOP);
            }
        }
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19603_, 300, 0, false, false));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setRedNose(this.m_21187_().nextDouble() < 0.1);
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setRedNose(compound.m_128471_("hasRedNose"));
        }
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasRedNose() {
        return this.hasVariant(0);
    }

    private void setRedNose(boolean b) {
        this.setVariant(0, b);
    }

    public boolean isEating() {
        return this.eatTimer > 0;
    }

    private void startEating() {
        this.eatTimer = 40;
        this.neckRotTimer = 0;
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.startEating();
        } else {
            super.m_7822_(id);
        }
    }
}

