/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity;

import com.github.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.github.klikli_dev.occultism.common.entity.FamiliarEntity;
import com.github.klikli_dev.occultism.common.entity.IFamiliar;
import com.github.klikli_dev.occultism.network.MessageFairySupport;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismAdvancements;
import com.github.klikli_dev.occultism.registry.OccultismParticles;
import com.github.klikli_dev.occultism.util.FamiliarUtil;
import com.mojang.math.Vector3f;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FairyFamiliarEntity
extends FamiliarEntity
implements FlyingAnimal {
    private static final EntityDataAccessor<Integer> MAGIC_TARGET = SynchedEntityData.m_135353_(FairyFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final float ANIMATION_HEIGHT_SPEED = 0.2f;
    private int saveCooldown = 0;
    private int supportAnim;

    public FairyFamiliarEntity(EntityType<? extends FairyFamiliarEntity> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WALKABLE, -1.0f);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.f_19811_ = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22276_, 18.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAGIC_TARGET, (Object)-1);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFlower()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(3, (Goal)new MagicGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 4.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
        this.f_21345_.m_25352_(8, (Goal)new SupportGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new SetAttackTargetGoal(this));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation navigator = new FlyingPathNavigation((Mob)this, pLevel){

            public void m_7638_() {
                super.m_7638_();
                BlockPos pos = this.f_26494_.m_142538_().m_7495_();
                BlockState below = this.f_26495_.m_8055_(pos);
                if (below.m_60795_()) {
                    if (this.f_26494_.f_20901_ < 0.0f) {
                        this.f_26494_.m_21567_(this.f_26494_.f_20901_ * 0.9f);
                    }
                    if (this.f_26494_.m_20184_().f_82480_ < 0.0) {
                        this.f_26494_.m_20256_(this.f_26494_.m_20184_().m_82542_(1.0, 0.9, 1.0));
                    }
                }
            }

            public boolean m_6342_(BlockPos pos) {
                BlockState state = this.f_26495_.m_8055_(pos);
                BlockState below = this.f_26495_.m_8055_(pos.m_7495_());
                return state.m_60795_() && below.m_60795_();
            }
        };
        return navigator;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isSitting()) {
            this.m_20256_(Vec3.f_82478_);
            this.f_20883_ = this.f_20884_;
        }
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
        this.partyParticle();
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null) {
            this.setMagicTarget(null);
        }
        if (this.f_19853_.f_46443_ && this.hasMagicTarget()) {
            this.f_20883_ = 0.0f;
            this.f_20884_ = 0.0f;
            this.magicParticle();
        }
        if (this.supportAnim > 0) {
            --this.supportAnim;
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        this.setTeeth(this.m_21187_().nextBoolean());
        this.m_21559_(this.m_21187_().nextBoolean());
        this.setFlower(this.m_21187_().nextDouble() < 0.1);
        return data;
    }

    public float getSupportAnim(float partialTicks) {
        if (this.supportAnim == 0) {
            return 0.0f;
        }
        return ((float)(20 - this.supportAnim) + partialTicks) / 20.0f;
    }

    public float getAnimationHeight(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + partialTicks) * 0.2f)) * 0.1f + 0.12f;
    }

    public float getWingRot(float partialTicks) {
        return Mth.m_14089_((float)(((float)this.f_19797_ + partialTicks) * 0.2f * 3.0f));
    }

    private float getPartyArmArg(float partialTicks) {
        return ((float)this.f_19797_ + partialTicks) * 0.2f;
    }

    public float getPartyArmRotX(float partialTicks) {
        return Mth.m_14089_((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f) - FamiliarUtil.toRads(90.0f);
    }

    public float getPartyArmRotY(float partialTicks) {
        return Mth.m_14031_((float)this.getPartyArmArg(partialTicks)) * FamiliarUtil.toRads(40.0f);
    }

    public boolean m_20068_() {
        return true;
    }

    private ParticleOptions createParticle() {
        return FamiliarUtil.isChristmas() ? (ParticleOptions)OccultismParticles.SNOWFLAKE.get() : new DustParticleOptions(new Vector3f(0.9f, 0.9f, 0.5f), 1.0f);
    }

    private void magicParticle() {
        Vec3 pos = this.getMagicPosition(1.0f);
        this.f_19853_.m_7106_(this.createParticle(), pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    private void partyParticle() {
        if (!this.f_19853_.f_46443_ || !this.isPartying() || this.f_19797_ % 2 != 0) {
            return;
        }
        Vec3 right = Vec3.m_82498_((float)0.0f, (float)this.f_20883_).m_82524_(FamiliarUtil.toRads(-90.0f));
        Vec3 armVector = new Vec3(0.0, -0.4, 0.0).m_82496_(this.getPartyArmRotX(0.0f)).m_82524_(-this.getPartyArmRotY(0.0f) + FamiliarUtil.toRads(-this.f_20883_ + 180.0f));
        Vec3 pos = this.m_20182_().m_82549_(right.m_82490_(0.2 * (double)(this.m_21526_() ? -1 : 1))).m_82520_(0.0, 0.7 + (double)this.getAnimationHeight(0.0f), 0.0).m_82549_(armVector);
        this.f_19853_.m_7106_(this.createParticle(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
    }

    public Vec2 getMagicRadiusAngle(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return Vec2.f_82462_;
        }
        float radius = target.m_20205_() * 1.2f;
        float angle = ((float)this.f_19797_ + partialTicks) * 0.1f;
        return new Vec2(radius, angle);
    }

    public Vec3 getMagicPosition(float partialTicks) {
        Entity target = this.getMagicTarget();
        if (target == null) {
            return null;
        }
        Vec3 targetPos = target.m_20318_(partialTicks).m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        Vec2 radiusAngle = this.getMagicRadiusAngle(partialTicks);
        Vec3 offset = new Vec3((double)(Mth.m_14089_((float)radiusAngle.f_82471_) * radiusAngle.f_82470_), 0.0, (double)(Mth.m_14031_((float)radiusAngle.f_82471_) * radiusAngle.f_82470_));
        return targetPos.m_82549_(offset);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return Collections.emptyList();
    }

    @Override
    public void curioTick(LivingEntity wearer) {
        if (this.saveCooldown > 0) {
            --this.saveCooldown;
        }
    }

    public boolean hasTeeth() {
        return this.hasVariant(0);
    }

    private void setTeeth(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasFlower() {
        return this.hasVariant(1);
    }

    private void setFlower(boolean b) {
        this.setVariant(1, b);
    }

    public Entity getMagicTarget() {
        int id = (Integer)this.f_19804_.m_135370_(MAGIC_TARGET);
        if (id < 0) {
            return null;
        }
        return this.f_19853_.m_6815_(id);
    }

    private void setMagicTarget(Entity entity) {
        int id = entity == null ? -1 : entity.m_142049_();
        this.f_19804_.m_135381_(MAGIC_TARGET, (Object)id);
    }

    public boolean hasMagicTarget() {
        return this.getMagicTarget() != null;
    }

    public boolean saveFamiliar(IFamiliar familiar) {
        if (this.saveCooldown > 0 || this.isSitting()) {
            return false;
        }
        this.saveCooldown = 400;
        if (!familiar.getFamiliarEntity().f_19853_.f_46443_) {
            OccultismPackets.sendToTracking((Entity)this, new MessageFairySupport(this.m_142049_(), familiar.getFamiliarEntity().m_142049_()));
        }
        return true;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_19378_() && this.getMagicTarget() != null) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource p_147189_) {
        return false;
    }

    public void m_7334_(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.m_7334_(pEntity);
    }

    protected void m_7324_(Entity pEntity) {
        if (this.hasMagicTarget()) {
            return;
        }
        super.m_7324_(pEntity);
    }

    public boolean m_6087_() {
        return !this.hasMagicTarget();
    }

    public void startSupportAnimation() {
        this.supportAnim = 20;
    }

    public boolean m_142592_() {
        return !this.f_19861_;
    }

    private static class MagicGoal
    extends MeleeAttackGoal {
        private final FairyFamiliarEntity fairy;
        private int attackTimer;

        public MagicGoal(FairyFamiliarEntity fairy) {
            super((PathfinderMob)fairy, 1.8, true);
            this.fairy = fairy;
        }

        public void m_8056_() {
            super.m_8056_();
            this.attackTimer = 20;
        }

        public void m_8041_() {
            super.m_8041_();
            this.fairy.setMagicTarget(null);
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            --this.attackTimer;
            double reach = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= reach) {
                this.fairy.setMagicTarget((Entity)pEnemy);
                if (this.attackTimer <= 0) {
                    this.attackTimer = 20;
                    LivingEntity owner = this.fairy.getFamiliarOwner();
                    if (owner != null) {
                        pEnemy.m_6469_(DamageSource.m_19370_((LivingEntity)owner), 1.0f);
                        pEnemy.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 1));
                        List allies = this.fairy.f_19853_.m_6443_(LivingEntity.class, this.fairy.m_142469_().m_82400_(7.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
                        allies.add(owner);
                        for (LivingEntity ally : allies) {
                            ally.m_5634_(1.0f);
                            ((ServerLevel)this.fairy.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, ally.m_20185_(), ally.m_20186_() + (double)ally.m_20206_(), ally.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                    }
                }
            } else if (pDistToEnemySqr > reach * 3.0) {
                this.fairy.setMagicTarget(null);
            }
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return super.m_6639_(pAttackTarget) * 3.0;
        }
    }

    private static class SupportGoal
    extends Goal {
        private static final int DURATION = 200;
        private final FairyFamiliarEntity fairy;
        private final Map<UUID, Integer> cooldowns;

        private SupportGoal(FairyFamiliarEntity fairy) {
            this.fairy = fairy;
            this.cooldowns = new HashMap<UUID, Integer>();
        }

        public boolean m_8036_() {
            return !this.fairy.isSitting() && this.fairy.getFamiliarEntity() != null;
        }

        public void m_8037_() {
            for (Map.Entry<UUID, Integer> entry : this.cooldowns.entrySet()) {
                if (entry.getValue() <= 0) continue;
                this.cooldowns.put(entry.getKey(), entry.getValue() - 1);
            }
            if (this.fairy.f_19797_ % 5 != 0) {
                return;
            }
            LivingEntity owner = this.fairy.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            List familiars = this.fairy.f_19853_.m_6443_(Mob.class, this.fairy.m_142469_().m_82400_(10.0), e -> e != this.fairy && e instanceof IFamiliar && ((IFamiliar)e).getFamiliarOwner() == owner);
            for (Mob familiar : familiars) {
                boolean gaveSupport;
                UUID id = familiar.m_142081_();
                if (!this.cooldowns.containsKey(id)) {
                    this.cooldowns.put(id, 0);
                }
                if (this.cooldowns.get(id) != 0) continue;
                boolean bl = gaveSupport = familiar.m_6060_() && familiar.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200));
                if (familiar.m_20069_() && familiar.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 200))) {
                    gaveSupport = true;
                }
                if (!familiar.m_20068_() && familiar.f_19789_ > 3.0f && familiar.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200))) {
                    gaveSupport = true;
                }
                if (familiar.m_21573_().m_26572_() && familiar.m_21573_().m_26567_().m_123331_((Vec3i)familiar.m_142538_()) > 100.0 && familiar.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200))) {
                    gaveSupport = true;
                }
                if (familiar.m_142581_() != null && familiar.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200))) {
                    gaveSupport = true;
                }
                if (!gaveSupport) continue;
                OccultismPackets.sendToTracking((Entity)this.fairy, new MessageFairySupport(this.fairy.m_142049_(), familiar.m_142049_()));
                this.cooldowns.put(id, 200);
            }
        }
    }

    public static class SetAttackTargetGoal
    extends TargetGoal {
        private final FamiliarEntity entity;
        private int timestamp;

        public SetAttackTargetGoal(FamiliarEntity entity) {
            super((Mob)entity, false);
            this.entity = entity;
        }

        public boolean m_8036_() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return false;
            }
            if (owner.m_20280_((Entity)this.entity) >= 400.0) {
                return false;
            }
            if (this.timestamp == owner.m_21215_()) {
                return false;
            }
            LivingEntity target = owner.m_21214_();
            return target != null && !(target instanceof Player) && !(target instanceof IFamiliar);
        }

        public boolean m_8045_() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            return super.m_8045_() && owner != null && owner.m_20280_((Entity)this.entity) < 400.0;
        }

        public void m_8056_() {
            LivingEntity owner = this.entity.getFamiliarOwner();
            if (owner == null) {
                return;
            }
            this.entity.m_6710_(owner.m_21214_());
            this.timestamp = owner.m_21215_();
            super.m_8056_();
        }
    }
}

