/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.ai.PausableGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.ManageMachineJob;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FallbackDepositToControllerGoal
extends PausableGoal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected ManageMachineJob job;
    protected int retries = 0;

    public FallbackDepositToControllerGoal(SpiritEntity entity, ManageMachineJob job) {
        this.entity = entity;
        this.job = job;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (this.entity.m_5448_() != null) {
            return false;
        }
        if (this.job.getStorageController() == null) {
            return false;
        }
        return !this.isPaused() && !this.entity.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !this.entity.getDepositPosition().isPresent();
    }

    @Override
    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        BlockEntity storageProxy = this.findClosestStorageProxy();
        if (storageProxy != null) {
            this.entity.setDepositPosition(storageProxy.m_58899_());
            this.entity.setDepositFacing(Direction.UP);
        } else {
            if (this.retries <= 60) {
                ++this.retries;
            }
            this.pause((long)this.retries * 10000L);
        }
    }

    protected BlockEntity findClosestStorageProxy() {
        Level level = this.entity.f_19853_;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        BlockPos machinePosition = this.job.getManagedMachine().globalPos.getPos();
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        List searchBlocks = BlockPos.m_121990_((BlockPos)machinePosition.m_142082_(-workAreaSize, -workAreaSize / 2, -workAreaSize), (BlockPos)machinePosition.m_142082_(workAreaSize, workAreaSize / 2, workAreaSize)).map(BlockPos::m_7949_).collect(Collectors.toList());
        for (BlockPos pos : searchBlocks) {
            IStorageControllerProxy proxy;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof IStorageControllerProxy) || (proxy = (IStorageControllerProxy)blockEntity).getLinkedStorageControllerPosition() == null || !proxy.getLinkedStorageControllerPosition().equals(this.job.getStorageControllerPosition())) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            return level.m_7702_((BlockPos)allBlocks.get(0));
        }
        return null;
    }
}

