/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.job;

import com.github.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.github.klikli_dev.occultism.common.entity.ai.DepositItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.FellTreesGoal;
import com.github.klikli_dev.occultism.common.entity.ai.PickupItemsGoal;
import com.github.klikli_dev.occultism.common.entity.ai.ReplantSaplingGoal;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.common.job.SpiritJob;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.common.misc.ItemTagComparator;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LumberjackJob
extends SpiritJob {
    protected EntityDimensions lumberJackDimensions;
    protected ReplantSaplingGoal replantSaplingGoal;
    protected PickupItemsGoal pickupItemsGoal;
    protected FellTreesGoal fellTreesGoal;
    protected DepositItemsGoal depositItemsGoal;
    protected List<IItemStackComparator> itemsToPickUp = new ArrayList<IItemStackComparator>();
    private Set<BlockPos> ignoredTrees = new HashSet<BlockPos>();
    private BlockPos lastFelledTree = null;

    public LumberjackJob(SpiritEntity entity) {
        super(entity);
        this.lumberJackDimensions = EntityDimensions.m_20395_((float)0.9f, (float)0.9f);
    }

    @Override
    public void init() {
        this.pickupItemsGoal = new PickupItemsGoal(this.entity, 4.0f, 10);
        this.entity.f_21345_.m_25352_(0, (Goal)this.pickupItemsGoal);
        this.fellTreesGoal = new FellTreesGoal(this.entity);
        this.entity.f_21345_.m_25352_(2, (Goal)this.fellTreesGoal);
        this.replantSaplingGoal = new ReplantSaplingGoal(this.entity);
        this.entity.f_21345_.m_25352_(3, (Goal)this.replantSaplingGoal);
        this.depositItemsGoal = new DepositItemsGoal(this.entity);
        this.entity.f_21345_.m_25352_(4, (Goal)this.depositItemsGoal);
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.f_13182_));
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.f_13143_));
        this.itemsToPickUp.add(new ItemTagComparator((Tag<Item>)ItemTags.f_13180_));
        this.itemsToPickUp.add(new ItemTagComparator(OccultismTags.FRUITS));
        this.itemsToPickUp.add(new ItemStackComparator(new ItemStack((ItemLike)Items.f_42398_), false));
    }

    @Override
    public void cleanup() {
        this.entity.f_21346_.m_25363_((Goal)this.replantSaplingGoal);
        this.entity.f_21346_.m_25363_((Goal)this.pickupItemsGoal);
        this.entity.f_21345_.m_25363_((Goal)this.fellTreesGoal);
        this.entity.f_21345_.m_25363_((Goal)this.depositItemsGoal);
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        for (IItemStackComparator comparator : this.itemsToPickUp) {
            if (!comparator.matches(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public EntityDimensions getDimensions(Pose pPose, EntityDimensions original) {
        return this.fellTreesGoal != null ? (this.fellTreesGoal.shouldUseLumberjackDimensions() ? this.lumberJackDimensions : original) : null;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        ListTag list = new ListTag();
        for (BlockPos ignoredTree : this.ignoredTrees) {
            list.add((Object)LongTag.m_128882_((long)ignoredTree.m_121878_()));
        }
        compound.m_128365_("ignoredTrees", (net.minecraft.nbt.Tag)list);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.ignoredTrees = new HashSet<BlockPos>();
        if (nbt.m_128441_("ignoredTrees")) {
            ListTag list = nbt.m_128437_("ignoredTrees", 9);
            for (int i = 0; i < list.size(); ++i) {
                this.ignoredTrees.add(BlockPos.m_122022_((long)((LongTag)list.get(i)).m_7046_()));
            }
        }
    }

    public Set<BlockPos> getIgnoredTrees() {
        return this.ignoredTrees;
    }

    public void setIgnoredTrees(Set<BlockPos> ignoredTrees) {
        this.ignoredTrees = ignoredTrees;
    }

    public BlockPos getLastFelledTree() {
        return this.lastFelledTree;
    }

    public void setLastFelledTree(BlockPos lastFelledTree) {
        this.lastFelledTree = lastFelledTree;
    }
}

