/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.config;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class OccultismCommonConfig {
    public final WorldGenSettings worldGen;
    public final ForgeConfigSpec spec;

    public OccultismCommonConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.worldGen = new WorldGenSettings(builder);
        this.spec = builder.build();
    }

    public static class WorldGenSettings {
        public final OreGenSettings oreGen;
        public final UndergroundGroveGenSettings undergroundGroveGen;

        public WorldGenSettings(ForgeConfigSpec.Builder builder) {
            builder.comment("WorldGen Settings").push("worldgen");
            this.oreGen = new OreGenSettings(builder);
            this.undergroundGroveGen = new UndergroundGroveGenSettings(builder);
            builder.pop();
        }

        public static class OreGenSettings {
            public final OreSettings silverOre;
            public final OreSettings silverOreDeepslate;
            public final OreSettings iesniumOre;

            public OreGenSettings(ForgeConfigSpec.Builder builder) {
                builder.comment("Ore Gen Settings").push("oregen");
                this.silverOre = new OreSettings("silverOre", (Tag<Block>)BlockTags.f_144266_, 7, 3, 50, 0, 200, builder);
                this.silverOreDeepslate = new OreSettings("silverOreDeepslate", (Tag<Block>)BlockTags.f_144267_, 7, 3, -64, 0, 50, builder);
                this.iesniumOre = new OreSettings("iesniumOre", (Tag<Block>)BlockTags.f_13062_, 3, 10, 10, 10, 128, builder);
                builder.pop();
            }

            public static class OreSettings {
                public final ForgeConfigSpec.BooleanValue generateOre;
                public final ForgeConfigSpec.ConfigValue<String> fillerBlockTag;
                public final ForgeConfigSpec.IntValue size;
                public final ForgeConfigSpec.IntValue count;
                public final ForgeConfigSpec.IntValue minimum;
                public final ForgeConfigSpec.IntValue maximum;

                public OreSettings(String oreName, Tag<Block> fillerBlockTag, int size, int count, int minimum, int topOffset, int maximum, ForgeConfigSpec.Builder builder) {
                    builder.comment("Ore Settings").push(oreName);
                    this.generateOre = builder.comment("True to generate this ore.").define("generateOre", true);
                    this.fillerBlockTag = builder.comment("The tag for the blocks this ore will spawn in.").define("fillerBlockTag", (Object)BlockTags.m_13115_().m_7473_(fillerBlockTag).toString());
                    this.size = builder.comment("The size of veins for this ore.").defineInRange("size", size, 0, 127);
                    this.count = builder.comment("The count value for the decorator for this ore.").defineInRange("count", count, 0, 127);
                    this.minimum = builder.comment("Range configuration min height.").defineInRange("bottomOffset", minimum, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    this.maximum = builder.comment("Range configuration max height. A negative max height is interpreted as offset from the top of the world (relevant for nether)").defineInRange("maximum", maximum, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    builder.pop();
                }

                public Tag<Block> getFillerBlockTag() {
                    return BlockTags.createOptional((ResourceLocation)new ResourceLocation((String)this.fillerBlockTag.get()));
                }
            }
        }

        public static class UndergroundGroveGenSettings {
            public final ForgeConfigSpec.BooleanValue generateUndergroundGroves;
            public final ForgeConfigSpec.IntValue groveSpawnChance;
            public final ForgeConfigSpec.IntValue groveSpawnMin;
            public final ForgeConfigSpec.IntValue groveSpawnMax;
            public final ForgeConfigSpec.DoubleValue grassChance;
            public final ForgeConfigSpec.DoubleValue treeChance;
            public final ForgeConfigSpec.DoubleValue vineChance;
            public final ForgeConfigSpec.DoubleValue ceilingLightChance;
            public final ForgeConfigSpec.ConfigValue<List<String>> biomeTypeBlacklist;

            public UndergroundGroveGenSettings(ForgeConfigSpec.Builder builder) {
                builder.comment("Underground Grove Settings").push("underground_grove");
                this.generateUndergroundGroves = builder.comment("True to generate underground groves. Should not be changed in most scenarios.").define("generateUndergroundGroves", true);
                this.groveSpawnChance = builder.comment("The chance for a grove to spawn in a chunk (generates 1/groveSpawnChance chunks on average).").defineInRange("groveSpawnChance", 400, 0, Integer.MAX_VALUE);
                this.groveSpawnMin = builder.comment("The min height for a grove to spawn (applied to the center of the grove, not the floor).").defineInRange("groveSpawnMin", 25, 0, 512);
                this.groveSpawnMax = builder.comment("The max height for a grove to spawn (applied to the center of the grove, not the ceiling).").defineInRange("groveSpawnMax", 60, 0, 512);
                this.grassChance = builder.comment("The chance grass will spawn in the underground grove.").defineInRange("grassChance", 0.6, 0.0, 1.0);
                this.treeChance = builder.comment("The chance small trees will spawn in the underground grove.").defineInRange("treeChance", 0.1, 0.0, 1.0);
                this.vineChance = builder.comment("The chance vines will spawn in the underground grove.").defineInRange("vineChance", 0.3, 0.0, 1.0);
                this.ceilingLightChance = builder.comment("The chance glowstone will spawn in the ceiling of the underground grove.").defineInRange("ceilingLightChance", 0.1, 0.0, 1.0);
                List defaultBiomeTypeBlacklist = Stream.of(BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END).map(BiomeDictionary.Type::getName).collect(Collectors.toList());
                this.biomeTypeBlacklist = builder.comment("The biome types the underground grove cannot spawn in.").define("biomeTypeBlacklist", defaultBiomeTypeBlacklist);
                builder.pop();
            }
        }
    }
}

