/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.github.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.github.klikli_dev.occultism.integration.jei.JeiSettings;
import com.github.klikli_dev.occultism.integration.jei.StorageControllerRecipeTransferHandler;
import com.github.klikli_dev.occultism.integration.jei.recipes.CrushingRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.MinerRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.RitualRecipeCategory;
import com.github.klikli_dev.occultism.integration.jei.recipes.SpiritFireRecipeCategory;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import com.github.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    protected static IJeiRuntime runtime;

    public static IJeiRuntime getJeiRuntime() {
        return runtime;
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("occultism", "jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SpiritFireRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RecipeManager recipeManager = level.m_7465_();
        List spiritFireRecipes = recipeManager.m_44013_((RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get());
        registration.addRecipes((Collection)spiritFireRecipes, OccultismRecipes.SPIRIT_FIRE.getId());
        List crushingRecipes = recipeManager.m_44013_((RecipeType)OccultismRecipes.CRUSHING_TYPE.get());
        registration.addRecipes((Collection)crushingRecipes, OccultismRecipes.CRUSHING.getId());
        List minerRecipes = recipeManager.m_44013_((RecipeType)OccultismRecipes.MINER_TYPE.get());
        registration.addRecipes((Collection)minerRecipes, OccultismRecipes.MINER.getId());
        List ritualRecipes = recipeManager.m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get());
        registration.addRecipes((Collection)ritualRecipes, OccultismRecipes.RITUAL.getId());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.TALLOW.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERSTONE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LOG.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LEAVES.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.IESNIUM_ORE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.SPIRIT_FIRE.get());
    }

    public void registerIngredientInfo(IRecipeRegistration registration, ItemLike ingredient) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ingredient.m_5456_()), VanillaTypes.ITEM, new Component[]{new TranslatableComponent("jei.occultism.ingredient." + ingredient.m_5456_().getRegistryName().m_135815_() + ".description")});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageControllerContainer, CraftingRecipe>(StorageControllerContainer.class, CraftingRecipe.class, handlerHelper), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageRemoteContainer, CraftingRecipe>(StorageRemoteContainer.class, CraftingRecipe.class, handlerHelper), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StableWormholeContainer, CraftingRecipe>(StableWormholeContainer.class, CraftingRecipe.class, handlerHelper), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.SPIRIT_FIRE.get()), new ResourceLocation[]{OccultismRecipes.SPIRIT_FIRE.getId()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), new ResourceLocation[]{OccultismRecipes.MINER.getId()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()), new ResourceLocation[]{OccultismRecipes.RITUAL.getId()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        JeiSettings.setJeiLoaded(true);
    }
}

