/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.jei;

import com.github.klikli_dev.occultism.network.MessageSetRecipe;
import com.github.klikli_dev.occultism.network.MessageSetRecipeByID;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class StorageControllerRecipeTransferHandler<T extends AbstractContainerMenu, R extends Recipe<?>>
implements IRecipeTransferHandler<T, R> {
    protected final Class<T> containerClass;
    protected final Class<R> recipeClass;
    protected final IRecipeTransferHandlerHelper handlerHelper;

    public StorageControllerRecipeTransferHandler(Class<T> containerClass, Class<R> recipeClass, IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
        this.recipeClass = recipeClass;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Class<R> getRecipeClass() {
        return this.recipeClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, R recipe, IRecipeLayout recipeLayout, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.m_6423_() == null) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("jei.occultismerror.missing_id"));
        }
        if (!recipe.m_8004_(3, 3)) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)new TranslatableComponent("jei.occultismerror.recipe_too_large"));
        }
        if (doTransfer) {
            if (player.m_20193_().m_7465_().m_44043_(recipe.m_6423_()).isPresent()) {
                OccultismPackets.sendToServer(new MessageSetRecipeByID(recipe.m_6423_()));
            } else {
                OccultismPackets.sendToServer(new MessageSetRecipe(this.recipeToTag((AbstractContainerMenu)container, recipeLayout)));
            }
        }
        return null;
    }

    public CompoundTag recipeToTag(AbstractContainerMenu container, IRecipeLayout recipeLayout) {
        CompoundTag nbt = new CompoundTag();
        Map inputs = recipeLayout.getItemStacks().getGuiIngredients();
        for (Slot slot : container.f_38839_) {
            List possibleItems;
            IGuiIngredient ingredient;
            if (!(slot.f_40218_ instanceof CraftingContainer) || (ingredient = (IGuiIngredient)inputs.get(slot.getSlotIndex() + 1)) == null || (possibleItems = ingredient.getAllIngredients()).isEmpty()) continue;
            ListTag invList = new ListTag();
            for (int i = 0; i < possibleItems.size() && i < 5; ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.m_41619_()) continue;
                invList.add((Object)itemStack.serializeNBT());
            }
            nbt.m_128365_("s" + slot.getSlotIndex(), (Tag)invList);
        }
        return nbt;
    }
}

