/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.integration.patchouli;

import com.github.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.github.klikli_dev.occultism.registry.OccultismBlocks;
import com.github.klikli_dev.occultism.registry.OccultismItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class RitualRecipeProcessor
implements IComponentProcessor {
    protected RitualRecipe recipe;
    protected ItemStack sacrificialBowl;

    public void setup(IVariableProvider iVariableProvider) {
        String recipeId = iVariableProvider.get("recipe").asString();
        this.recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(new ResourceLocation(recipeId)).orElse(null);
        this.sacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get());
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return IVariable.empty();
        }
        if (key.startsWith("ritual_dummy")) {
            return IVariable.from((Object)this.recipe.getRitualDummy());
        }
        if (key.startsWith("activation_item")) {
            return IVariable.from((Object)this.recipe.getActivationItem().m_43908_());
        }
        if (key.startsWith("pentacle") && this.recipe.getPentacle() != null) {
            String pentacleName = I18n.m_118938_((String)this.recipe.getPentacle().getDescriptionId(), (Object[])new Object[0]);
            String pentacleLink = "pentacles/" + this.recipe.getPentacleId().m_135815_();
            return IVariable.wrap((String)String.format("$(l:%s)%s$(/l)", pentacleLink, pentacleName));
        }
        if (key.startsWith("ingredient")) {
            int index = Integer.parseInt(key.substring("ingredient".length())) - 1;
            if (index >= this.recipe.m_7527_().size()) {
                return IVariable.empty();
            }
            Ingredient ingredient = (Ingredient)this.recipe.m_7527_().get(index);
            return IVariable.from((Object)ingredient.m_43908_());
        }
        if (key.startsWith("bowl")) {
            int index = Integer.parseInt(key.substring("bowl".length())) - 1;
            if (index >= this.recipe.m_7527_().size()) {
                return IVariable.empty();
            }
            return IVariable.from((Object)this.sacrificialBowl);
        }
        if (key.equals("output")) {
            if (this.recipe.m_8043_().m_41720_() != OccultismItems.JEI_DUMMY_NONE.get()) {
                return IVariable.from((Object)this.recipe.m_8043_());
            }
            return IVariable.from((Object)this.recipe.getRitualDummy());
        }
        if (key.equals("entity_to_summon") && this.recipe.getEntityToSummon() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.occultism.summon", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToSummon().m_20675_(), (Object[])new Object[0])}));
        }
        if (key.equals("job") && this.recipe.getSpiritJobType() != null) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.occultism.job", (Object[])new Object[]{I18n.m_118938_((String)("job." + this.recipe.getSpiritJobType().toString().replace(":", ".")), (Object[])new Object[0])}));
        }
        if (key.equals("entity_to_sacrifice") && this.recipe.requiresSacrifice()) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.occultism.sacrifice", (Object[])new Object[]{I18n.m_118938_((String)this.recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])}));
        }
        if (key.equals("item_to_use") && this.recipe.requiresItemUse()) {
            return IVariable.from((Object)this.recipe.getItemToUse().m_43908_());
        }
        if (key.equals("item_to_use_text") && this.recipe.requiresItemUse()) {
            return IVariable.wrap((String)I18n.m_118938_((String)"jei.occultism.item_to_use", (Object[])new Object[0]));
        }
        return IVariable.empty();
    }
}

