/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.StorageUtil;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetRecipe
extends MessageBase {
    private CompoundTag nbt;
    private int index = 0;

    public MessageSetRecipe(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipe(CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        if (!(player.f_36096_ instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)player.f_36096_;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        block0: for (int slot = 0; slot < 9; ++slot) {
            int i;
            HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
            ListTag invList = this.nbt.m_128437_("s" + slot, 10);
            for (i = 0; i < invList.size(); ++i) {
                ItemStack s = ItemStack.m_41712_((CompoundTag)invList.m_128728_(i));
                map.put(i, s);
            }
            for (i = 0; i < map.size(); ++i) {
                ItemStack stack = (ItemStack)map.get(i);
                if (stack == null || stack.m_41619_()) continue;
                ItemStackComparator comparator = new ItemStackComparator(stack, true);
                ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), comparator, 1, true);
                if (extractedStack != null && !extractedStack.m_41619_() && craftMatrix.m_8020_(slot).m_41619_()) {
                    StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), comparator, 1, false);
                    craftMatrix.m_6836_(slot, extractedStack);
                    continue block0;
                }
                if ((stack = storageController.getItemStack(!stack.m_41619_() ? comparator : null, 1, false)).m_41619_() || !craftMatrix.m_8020_(slot).m_41619_()) continue;
                craftMatrix.m_6836_(slot, stack);
                continue block0;
            }
        }
        container.updateCraftingSlots(true);
        OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
        buf.writeInt(this.index);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.nbt = buf.m_130260_();
        this.index = buf.readInt();
    }
}

