/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.util.StorageUtil;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetRecipeByID
extends MessageBase {
    private ResourceLocation id;

    public MessageSetRecipeByID(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetRecipeByID(ResourceLocation id) {
        this.id = id;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        if (!(player.f_36096_ instanceof IStorageControllerContainer)) {
            return;
        }
        IStorageControllerContainer container = (IStorageControllerContainer)player.f_36096_;
        IStorageController storageController = container.getStorageController();
        if (storageController == null) {
            return;
        }
        Recipe recipe = player.m_183503_().m_7465_().m_44043_(this.id).orElse(null);
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0);
        StorageUtil.clearOpenCraftingMatrix(player, false);
        CraftingContainer craftMatrix = container.getCraftMatrix();
        NonNullList<Ingredient> ingredients = this.getIngredientsForRecipe(recipe);
        for (int slot = 0; slot < 9; ++slot) {
            Ingredient ingredient = (Ingredient)ingredients.get(slot);
            ItemStack extractedStack = StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), (Predicate<ItemStack>)ingredient, 1, true);
            if (extractedStack != null && !extractedStack.m_41619_() && craftMatrix.m_8020_(slot).m_41619_()) {
                StorageUtil.extractItem((IItemHandler)new PlayerMainInvWrapper(player.m_150109_()), (Predicate<ItemStack>)ingredient, 1, false);
                craftMatrix.m_6836_(slot, extractedStack);
                continue;
            }
            extractedStack = storageController.getItemStack((Predicate<ItemStack>)ingredient, 1, false);
            if (extractedStack.m_41619_() || !craftMatrix.m_8020_(slot).m_41619_()) continue;
            craftMatrix.m_6836_(slot, extractedStack);
        }
        container.updateCraftingSlots(true);
        OccultismPackets.sendTo(player, storageController.getMessageUpdateStacks());
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.id);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.id = buf.m_130281_();
    }

    private NonNullList<Ingredient> getIngredientsForRecipe(Recipe<?> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        NonNullList ingredientsMatrixGrid = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() <= 9 ? 1 : 0) != 0);
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)recipe;
            int width = shapedRecipe.getRecipeWidth();
            int height = shapedRecipe.getRecipeHeight();
            Preconditions.checkArgument((width <= 3 && height <= 3 ? 1 : 0) != 0);
            for (int h = 0; h < height; ++h) {
                for (int w = 0; w < width; ++w) {
                    int source = w + h * width;
                    int target = w + h * 3;
                    Ingredient i = (Ingredient)ingredients.get(source);
                    ingredientsMatrixGrid.set(target, (Object)i);
                }
            }
        } else {
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredientsMatrixGrid.set(i, (Object)((Ingredient)ingredients.get(i)));
            }
        }
        return ingredientsMatrixGrid;
    }
}

