/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdLadderBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.OptionalRecipeCondition;
import wile.engineersdecor.libmc.detail.Overlay;

@Mod(value="engineersdecor")
public class ModEngineersDecor {
    public static final String MODID = "engineersdecor";
    public static final String MODNAME = "Engineer's Decor";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CreativeModeTab ITEMGROUP = new CreativeModeTab("tabengineersdecor"){

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModContent.SIGN_MODLOGO);
        }
    };

    public ModEngineersDecor() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        OptionalRecipeCondition.init(MODID, LOGGER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ModConfig.SERVER_CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Registering recipe condition processor ...");
        CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
        Networking.init(MODID);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ModContent.registerContainerGuis(event);
        ModContent.registerTileEntityRenderers(event);
        ModContent.processContentClientSide(event);
        Overlay.register();
    }

    @SubscribeEvent
    public void onPlayerEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity;
        if (event.getEntity().f_19853_ == null || !((entity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_6147_()) {
            EdLadderBlock.onPlayerUpdateEvent(player);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            ModContent.registerItems(event);
            ModContent.registerBlockItems(event);
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<BlockEntityType<?>> event) {
            ModContent.registerTileEntities(event);
        }

        @SubscribeEvent
        public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
            ModContent.registerEntities(event);
        }

        @SubscribeEvent
        public static void onRegisterContainerTypes(RegistryEvent.Register<MenuType<?>> event) {
            ModContent.registerContainers(event);
        }

        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                ModEngineersDecor.logger().info("Config file changed {}", (Object)event.getConfig().getFileName());
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

