/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdCatwalkBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;

public class EdCatwalkTopAlignedBlock
extends StandardBlocks.WaterLoggable {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)3);
    protected final List<VoxelShape> variant_shapes;

    public EdCatwalkTopAlignedBlock(long config, BlockBehaviour.Properties properties, VoxelShape[] variant_shapes) {
        super(config, properties, variant_shapes[0]);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.variant_shapes = VARIANT.m_6908_().stream().map(i -> i < variant_shapes.length ? variant_shapes[i] : Shapes.m_83144_()).collect(Collectors.toList());
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.variant_shapes.get((Integer)state.m_61143_((Property)VARIANT));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.adapted_state(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
        if (context.m_43719_() != Direction.UP) {
            return state;
        }
        BlockState below = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if ((Integer)state.m_61143_((Property)VARIANT) == 0 && below.m_60783_((BlockGetter)context.m_43725_(), context.m_8083_().m_7495_(), Direction.UP)) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(3));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = player.m_21120_(hand).m_41720_();
        if (item != this.m_5456_()) {
            return InteractionResult.PASS;
        }
        if (hit.m_82434_().m_122434_().m_122479_()) {
            return InteractionResult.PASS;
        }
        BlockPos adjacent_pos = pos.m_142300_(player.m_6350_());
        BlockState adjacent_state = world.m_8055_(adjacent_pos);
        if (adjacent_state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, adjacent_pos, hit.m_82434_().m_122424_(), player.m_21120_(hand), hit.m_82434_()))) {
            BlockState place_state = this.m_49966_();
            place_state = (BlockState)place_state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.m_60819_().m_76152_() == Fluids.f_76193_));
            EdCatwalkBlock.place_consume(this.adapted_state(place_state, (LevelAccessor)world, adjacent_pos), world, adjacent_pos, player, hand, 1);
        }
        return world.m_5776_() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.adapted_state(super.m_7417_(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    private BlockState adapted_state(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState below = world.m_8055_(pos.m_7495_());
        if (below == null || state == null) {
            return state;
        }
        if (below.m_60734_() == ModContent.THICK_STEEL_POLE || below.m_60734_() == ModContent.THICK_STEEL_POLE_HEAD) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(1));
        }
        if (below.m_60734_() == ModContent.THIN_STEEL_POLE || below.m_60734_() == ModContent.THIN_STEEL_POLE_HEAD) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(2));
        }
        return state;
    }
}

