/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.eapi.jei;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.EdCraftingTable;
import wile.engineersdecor.libmc.detail.Auxiliaries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation(Auxiliaries.modid(), "jei_plugin_uid");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!ModConfig.isOptedOut(ModContent.CRAFTING_TABLE)) {
            try {
                registration.addRecipeTransferHandler(EdCraftingTable.CraftingTableUiContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 54);
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().warn("Exception in JEI crafting table handler registration: '" + e.getMessage() + "'.");
            }
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        HashSet<Item> blacklisted = new HashSet<Item>();
        for (Block block : ModContent.getRegisteredBlocks()) {
            if (!ModConfig.isOptedOut(block) || !block.m_5456_().getRegistryName().m_135815_().equals(block.getRegistryName().m_135815_())) continue;
            blacklisted.add(block.m_5456_());
        }
        for (Item item : ModContent.getRegisteredItems()) {
            if (!ModConfig.isOptedOut(item) || item instanceof BlockItem) continue;
            blacklisted.add(item);
        }
        if (!blacklisted.isEmpty()) {
            List blacklist = blacklisted.stream().map(ItemStack::new).collect(Collectors.toList());
            try {
                jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(VanillaTypes.ITEM, blacklist);
            }
            catch (Exception exception) {
                ModEngineersDecor.logger().warn("Exception in JEI opt-out processing: '" + exception.getMessage() + "', skipping further JEI optout processing.");
            }
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!ModConfig.isOptedOut(ModContent.CRAFTING_TABLE)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModContent.CRAFTING_TABLE), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        }
        if (!ModConfig.isOptedOut(ModContent.SMALL_LAB_FURNACE)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModContent.SMALL_LAB_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        }
        if (!ModConfig.isOptedOut(ModContent.SMALL_ELECTRICAL_FURNACE)) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModContent.SMALL_ELECTRICAL_FURNACE), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        }
    }
}

