/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.items;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.RFToolsBuilder;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.blocks.SpaceChamberControllerTileEntity;
import mcjty.rftoolsbuilder.modules.builder.client.GuiChamberDetails;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.Lazy;

public class SpaceChamberCardItem
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"cost", this::getCostDescription), TooltipBuilder.parameter((String)"channel", this::getChannelDescription), TooltipBuilder.general((String)"extra", (ChatFormatting[])new ChatFormatting[]{ChatFormatting.GRAY})});

    private String getCostDescription(ItemStack stack) {
        return BuilderConfiguration.builderRfPerOperation.get() + " RF/t per block";
    }

    private String getChannelDescription(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        int channel = -1;
        if (tag != null) {
            channel = tag.m_128451_("channel");
        }
        if (channel != -1) {
            return "Channel: " + channel;
        }
        return "Channel is not set!";
    }

    public SpaceChamberCardItem() {
        super(new Item.Properties().m_41487_(1).m_41499_(0).m_41491_(RFToolsBuilder.setup.getTab()));
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        if (!player.m_6047_()) {
            this.showDetails(world, player, player.m_21120_(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity te = level.m_7702_(pos);
        CompoundTag tagCompound = stack.m_41784_();
        int channel = -1;
        if (te instanceof SpaceChamberControllerTileEntity) {
            channel = ((SpaceChamberControllerTileEntity)te).getChannel();
        }
        if (channel == -1) {
            this.showDetails(level, player, stack);
        } else {
            tagCompound.m_128405_("channel", channel);
            if (level.f_46443_) {
                Logging.message((Player)player, (String)("Card is set to channel '" + channel + "'"));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void showDetails(Level world, Player player, ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("channel")) {
            int channel = stack.m_41783_().m_128451_("channel");
            if (channel != -1) {
                this.showDetailsGui(world, player);
            } else {
                Logging.message((Player)player, (String)(ChatFormatting.YELLOW + "Card is not linked!"));
            }
        }
    }

    private void showDetailsGui(Level world, Player player) {
        if (world.f_46443_) {
            GuiChamberDetails.open();
        }
    }
}

