/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.client.DelayedRenderer;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.blocks.VehicleBuilderTileEntity;
import mcjty.rftoolsbuilder.modules.mover.client.MoverRenderer;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class MoverTileEntity
extends TickingTileEntity {
    public static final int SLOT_VEHICLE_CARD = 0;
    public static final int MAXSCAN = 256;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific((Item[])new Item[]{(Item)MoverModule.VEHICLE_CARD.get()}).in().out(), 0, 154, 11).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).onUpdate((slot, stack) -> this.updateVehicle()).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)MoverConfiguration.MAXENERGY.get()).intValue(), (long)((Integer)MoverConfiguration.RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Mover").containerSupplier(DefaultContainerProvider.container(MoverModule.CONTAINER_MOVER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @GuiValue
    private String name;
    @GuiValue
    public static final Value<?, String> VALUE_CONNECTIONS = Value.create((String)"connections", (Type)Type.STRING, MoverTileEntity::getConnectionCount, MoverTileEntity::setConnectionCount);
    private String connections = "";
    private int cnt;
    private BlockPos destination = null;
    private long starttick;
    private float totalDist;
    private BlockPos source = null;
    private Set<BlockPos> invisibleMoverBlocks = null;
    private final Map<Integer, Vec3> grabbedEntities = new HashMap<Integer, Vec3>();
    private final Map<Direction, BlockPos> network = new EnumMap<Direction, BlockPos>(Direction.class);
    private final Random random = new Random();
    @ServerCommand
    public static final Command<?> CMD_SCAN = Command.create((String)"scan", (te, player, params) -> te.doScan());

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(MoverTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}));
    }

    public MoverTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.TYPE_MOVER.get(), pos, state);
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invisibleMoverBlocks != null) {
            this.removeInvisibleBlocks();
        }
    }

    protected void tickServer() {
        this.updateVehicleStatus();
        this.tryMoveVehicleServer();
    }

    protected void tickClient() {
        this.handleRender();
        this.tryMoveVehicleClient();
    }

    private void handleRender() {
        ItemStack vehicle = this.getCard();
        if (VehicleBuilderTileEntity.isVehicleCard(vehicle)) {
            DelayedRenderer.addRender((BlockPos)this.f_58858_, (poseStack, cameraVec) -> MoverRenderer.actualRender(this, poseStack, cameraVec, vehicle), (level, pos) -> {
                BlockEntity patt6191$temp = level.m_7702_(pos);
                if (patt6191$temp instanceof MoverTileEntity) {
                    MoverTileEntity mover = (MoverTileEntity)patt6191$temp;
                    return !mover.getCard().m_41619_();
                }
                return false;
            });
        }
    }

    private void tryMoveVehicleClient() {
        if (this.destination != null) {
            // empty if block
        }
    }

    public long getStarttick() {
        return this.starttick;
    }

    public float getTotalDist() {
        return this.totalDist;
    }

    public long getTotalTicks() {
        return (long)(this.totalDist * 50.0f);
    }

    public BlockPos getDestination() {
        return this.destination;
    }

    @NotNull
    public Vec3 getMovingPosition(float partialTicks, long gameTick) {
        BlockPos blockPos = this.f_58858_;
        BlockPos destination = this.getDestination();
        Vec3 current = new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        if (destination != null) {
            long totalTicks = this.getTotalTicks();
            long currentTick = gameTick - this.starttick;
            Vec3 dest = new Vec3((double)destination.m_123341_(), (double)destination.m_123342_(), (double)destination.m_123343_());
            current = current.m_165921_(dest, (double)((float)currentTick + partialTicks) / (double)totalTicks);
        }
        return current;
    }

    private void tryMoveVehicleServer() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (this.destination != null) {
            this.actualMoveServer(vehicle);
        } else if (!this.network.isEmpty() && this.isMachineEnabled() && !vehicle.m_41619_()) {
            this.actualStartMovementServer();
        }
    }

    private void actualStartMovementServer() {
        MoverTileEntity destMover;
        BlockEntity blockEntity;
        float r;
        Iterator<BlockPos> iterator = this.network.values().iterator();
        BlockPos dest = iterator.next();
        if (iterator.hasNext() && (r = this.random.nextFloat()) < 0.5f) {
            dest = iterator.next();
        }
        if ((blockEntity = this.f_58857_.m_7702_(dest)) instanceof MoverTileEntity && (destMover = (MoverTileEntity)blockEntity).isAvailable()) {
            destMover.setSource(this.f_58858_);
            this.destination = dest;
            this.totalDist = (float)Math.sqrt(this.f_58858_.m_123299_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), true));
            this.starttick = this.f_58857_.m_46467_();
            this.markDirtyClient();
        }
    }

    private void actualMoveServer(ItemStack vehicle) {
        long totalTicks = this.getTotalTicks();
        long currentTick = this.f_58857_.m_46467_() - this.starttick;
        Vec3 movingPosition = this.getMovingPosition(0.0f, this.f_58857_.m_46467_());
        AABB aabb = new AABB(movingPosition, movingPosition.m_82520_(5.0, 5.0, 5.0));
        Vec3 startPos = this.getMovingPosition(0.0f, this.starttick);
        Vec3 currentPos = this.getMovingPosition(0.0f, this.f_58857_.m_46467_());
        double dx = currentPos.f_82479_ - startPos.f_82479_;
        double dy = currentPos.f_82480_ - startPos.f_82480_;
        double dz = currentPos.f_82481_ - startPos.f_82481_;
        for (Entity blockEntity : this.f_58857_.m_45976_(Entity.class, aabb)) {
            if (this.grabbedEntities.containsKey(blockEntity.m_142049_())) {
                Vec3 basePos = this.grabbedEntities.get(blockEntity.m_142049_());
                blockEntity.m_6034_(basePos.f_82479_ + dx, basePos.f_82480_ + dy, basePos.f_82481_ + dz);
                blockEntity.f_19789_ = 0.0f;
                blockEntity.f_19788_ = 0.0f;
                blockEntity.f_146794_ = 0.0f;
                blockEntity.f_19787_ = 0.0f;
                blockEntity.f_19812_ = false;
                blockEntity.f_19794_ = true;
                blockEntity.m_20256_(Vec3.f_82478_);
                blockEntity.m_6853_(true);
                continue;
            }
            this.grabbedEntities.put(blockEntity.m_142049_(), blockEntity.m_20182_());
            blockEntity.f_19794_ = true;
            blockEntity.m_20256_(Vec3.f_82478_);
            blockEntity.m_6853_(true);
        }
        for (Map.Entry entry : this.grabbedEntities.entrySet()) {
            Entity entity = this.f_58857_.m_6815_(((Integer)entry.getKey()).intValue());
            Vec3 basePos = (Vec3)entry.getValue();
            entity.m_6034_(basePos.f_82479_ + dx, basePos.f_82480_ + dy, basePos.f_82481_ + dz);
            entity.f_19789_ = 0.0f;
            entity.f_19788_ = 0.0f;
            entity.f_146794_ = 0.0f;
            entity.f_19787_ = 0.0f;
            entity.f_19812_ = false;
            entity.f_19794_ = true;
            entity.m_20256_(Vec3.f_82478_);
            entity.m_6853_(true);
        }
        if (currentTick >= totalTicks) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.destination);
            if (blockEntity instanceof MoverTileEntity) {
                MoverTileEntity destMover = (MoverTileEntity)blockEntity;
                destMover.items.setStackInSlot(0, vehicle);
                this.items.setStackInSlot(0, ItemStack.f_41583_);
                destMover.setSource(null);
            }
            this.destination = null;
            this.markDirtyClient();
        }
    }

    private void updateVehicleStatus() {
        if (this.invisibleMoverBlocks == null) {
            this.updateVehicle();
            this.cnt = 0;
        }
        --this.cnt;
        if (this.cnt <= 0) {
            this.cnt = 4;
            BlockState invisibleState = ((Block)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
            this.invisibleMoverBlocks.forEach(p -> {
                if (this.f_58857_.m_8055_(p) != invisibleState && this.f_58857_.m_8055_(p).m_60767_().m_76336_()) {
                    this.f_58857_.m_7731_(p, invisibleState, 3);
                }
            });
        }
    }

    private void updateVehicle() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (this.invisibleMoverBlocks == null) {
            this.invisibleMoverBlocks = new HashSet<BlockPos>();
        }
        this.removeInvisibleBlocks();
        if (!vehicle.m_41619_()) {
            Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(vehicle, this.f_58858_.m_142082_(1, 1, 1));
            blocks.values().forEach(this.invisibleMoverBlocks::addAll);
        } else {
            this.destination = null;
        }
        this.markDirtyClient();
    }

    private void removeInvisibleBlocks() {
        BlockState invisibleState = ((Block)MoverModule.INVISIBLE_MOVER_BLOCK.get()).m_49966_();
        this.invisibleMoverBlocks.forEach(p -> {
            if (this.f_58857_.m_8055_(p) == invisibleState) {
                this.f_58857_.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
            }
        });
        this.invisibleMoverBlocks.clear();
    }

    public void setSource(BlockPos pos) {
        this.source = pos;
        this.m_6596_();
    }

    public boolean isAvailable() {
        ItemStack vehicle = this.items.getStackInSlot(0);
        if (!vehicle.m_41619_()) {
            return false;
        }
        if (this.destination != null) {
            return false;
        }
        return this.source == null;
    }

    public String getConnectionCount() {
        return this.connections;
    }

    public void setConnectionCount(String v) {
        this.connections = v;
    }

    public ItemStack getCard() {
        return this.items.getStackInSlot(0);
    }

    private void addConnection(Direction direction, BlockPos pos) {
        this.network.put(direction, pos);
        this.connections = this.connections + direction.name().toUpperCase().charAt(0);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!tagCompound.m_128441_(direction.name())) continue;
            this.addConnection(direction, NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_(direction.name())));
        }
        this.source = tagCompound.m_128441_("source") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("source")) : null;
        this.destination = tagCompound.m_128441_("destination") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("destination")) : null;
        this.starttick = tagCompound.m_128454_("starttick");
        this.totalDist = tagCompound.m_128457_("totalDist");
    }

    public void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.name = info.m_128461_("name");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            if (!this.network.containsKey(direction)) continue;
            tagCompound.m_128365_(direction.name(), (Tag)NbtUtils.m_129224_((BlockPos)this.network.get(direction)));
        }
        if (this.source != null) {
            tagCompound.m_128365_("source", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        }
        if (this.destination != null) {
            tagCompound.m_128365_("destination", (Tag)NbtUtils.m_129224_((BlockPos)this.destination));
        }
        tagCompound.m_128356_("starttick", this.starttick);
        tagCompound.m_128350_("totalDist", this.totalDist);
    }

    public void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        if (this.name != null) {
            info.m_128359_("name", this.name);
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.loadClientDataFromNBT(tag);
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        ItemStack card = this.items.getStackInSlot(0);
        CompoundTag tag = new CompoundTag();
        card.m_41739_(tag);
        tagCompound.m_128365_("card", (Tag)tag);
        tagCompound.m_128356_("starttick", this.starttick);
        tagCompound.m_128350_("totalDist", this.totalDist);
        if (this.destination != null) {
            tagCompound.m_128365_("destination", (Tag)NbtUtils.m_129224_((BlockPos)this.destination));
        }
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag tag = tagCompound.m_128469_("card");
        this.items.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)tag));
        this.destination = tagCompound.m_128441_("destination") ? NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("destination")) : null;
        this.starttick = tagCompound.m_128454_("starttick");
        this.totalDist = tagCompound.m_128457_("totalDist");
    }

    private void doScan() {
        this.network.clear();
        this.connections = "";
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        done.add(this.f_58858_);
        this.doScan(done, null);
        this.m_6596_();
    }

    private void doScanFromOther(Set<BlockPos> done, @Nonnull Direction comingFrom, BlockPos other) {
        this.network.clear();
        this.connections = "";
        this.addConnection(comingFrom.m_122424_(), other);
        this.doScan(done, comingFrom);
        this.m_6596_();
    }

    private void doScan(Set<BlockPos> done, @Nullable Direction comingFrom) {
        block0: for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockPos relative;
            if (Objects.equals(direction.m_122424_(), comingFrom)) continue;
            for (int i = 1; i < 256 && !done.contains(relative = this.f_58858_.m_5484_(direction, i)); ++i) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(relative);
                if (!(blockEntity instanceof MoverTileEntity)) continue;
                MoverTileEntity mover = (MoverTileEntity)blockEntity;
                done.add(relative);
                this.addConnection(direction, relative);
                mover.doScanFromOther(done, direction, this.f_58858_);
                continue block0;
            }
        }
    }
}

