/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbuilder.compat.RFToolsBuilderTOPDriver;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.BuilderTools;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import mcjty.rftoolsbuilder.modules.mover.MoverModule;
import mcjty.rftoolsbuilder.modules.mover.items.VehicleCard;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class VehicleBuilderTileEntity
extends GenericTileEntity {
    public static final int SLOT_SPACE_CARD = 0;
    public static final int SLOT_VEHICLE_CARD = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific((Item[])new Item[]{(Item)BuilderModule.SPACE_CHAMBER_CARD.get()}).in(), 0, 64, 24).slot(SlotDefinition.specific((Item[])new Item[]{(Item)MoverModule.VEHICLE_CARD.get()}).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = new GenericItemHandler((GenericTileEntity)this, (ContainerFactory)CONTAINER_FACTORY.get());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Vehicle Builder").containerSupplier(DefaultContainerProvider.container(MoverModule.CONTAINER_VEHICLE_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private static final int MAXDIM = 16;
    @ServerCommand
    public static final Command<?> CMD_CREATE = Command.create((String)"create", (te, player, params) -> te.copyVehicle(player));

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(VehicleBuilderTileEntity::new).topDriver((TOPDriver)RFToolsBuilderTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolsbuilder:todo")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}));
    }

    public VehicleBuilderTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)MoverModule.TYPE_VEHICLE_BUILDER.get(), pos, state);
    }

    public GenericItemHandler getItems() {
        return this.items;
    }

    private void copyVehicle(Player player) {
        BlockPos maxCorner;
        BlockPos minCorner;
        SpaceChamberRepository.SpaceChamberChannel chamberChannel;
        ItemStack spaceCard = this.items.getStackInSlot(0);
        ItemStack vehicleCard = this.items.getStackInSlot(1);
        if (VehicleBuilderTileEntity.isUsableSpaceCard(spaceCard) && VehicleBuilderTileEntity.isVehicleCard(vehicleCard) && (chamberChannel = BuilderTools.getSpaceChamberChannel(this.f_58857_, spaceCard)) != null && this.checkValid(player, minCorner = chamberChannel.getMinCorner(), maxCorner = chamberChannel.getMaxCorner())) {
            ResourceKey<Level> dimension = chamberChannel.getDimension();
            ServerLevel world = LevelTools.getLevel((Level)this.f_58857_, dimension);
            Map<BlockState, List<Integer>> blocks = this.getBlocks(minCorner, maxCorner, world);
            VehicleCard.storeVehicleInCard(vehicleCard, blocks);
        }
    }

    @NotNull
    private Map<BlockState, List<Integer>> getBlocks(BlockPos minCorner, BlockPos maxCorner, ServerLevel world) {
        HashMap<BlockState, List<Integer>> blocks = new HashMap<BlockState, List<Integer>>();
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int x = minCorner.m_123341_(); x <= maxCorner.m_123341_(); ++x) {
            mpos.m_142451_(x);
            for (int y = minCorner.m_123342_(); y <= maxCorner.m_123342_(); ++y) {
                mpos.m_142448_(y);
                for (int z = minCorner.m_123343_(); z <= maxCorner.m_123343_(); ++z) {
                    mpos.m_142443_(z);
                    BlockState state = world.m_8055_((BlockPos)mpos);
                    if (state.m_60795_()) continue;
                    blocks.computeIfAbsent(state, s -> new ArrayList()).add(VehicleCard.convertPosToInt(minCorner, (BlockPos)mpos));
                }
            }
        }
        return blocks;
    }

    private boolean checkValid(Player player, BlockPos minCorner, BlockPos maxCorner) {
        if (maxCorner.m_123341_() - minCorner.m_123341_() >= 16) {
            player.m_6352_((Component)new TextComponent("Space chamber too large (max 16x16x16)!"), Util.f_137441_);
            return false;
        }
        if (maxCorner.m_123342_() - minCorner.m_123342_() >= 16) {
            player.m_6352_((Component)new TextComponent("Space chamber too large (max 16x16x16)!"), Util.f_137441_);
            return false;
        }
        if (maxCorner.m_123343_() - minCorner.m_123343_() >= 16) {
            player.m_6352_((Component)new TextComponent("Space chamber too large (max 16x16x16)!"), Util.f_137441_);
            return false;
        }
        return true;
    }

    public static boolean isUsableSpaceCard(ItemStack stack) {
        if (stack.m_41720_() != BuilderModule.SPACE_CHAMBER_CARD.get()) {
            return false;
        }
        return BuilderTools.getChannel(stack) != null;
    }

    public static boolean isVehicleCard(ItemStack stack) {
        return stack.m_41720_() == MoverModule.VEHICLE_CARD.get();
    }
}

