/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.rftoolsbuilder.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class VehicleCard
extends Item
implements ITooltipSettings {
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsbuilder.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"contents", VehicleCard::getContentsDescription)});

    public VehicleCard() {
        super(Registration.createStandardProperties().m_41487_(1));
    }

    private static String getContentsDescription(ItemStack stack) {
        Map<BlockState, List<BlockPos>> blocks = VehicleCard.getBlocks(stack, BlockPos.f_121853_);
        int cnt = 0;
        for (List<BlockPos> list : blocks.values()) {
            cnt += list.size();
        }
        return cnt + " blocks";
    }

    public void m_7373_(@Nonnull ItemStack itemStack, Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    public static void storeVehicleInCard(ItemStack vehicleCard, Map<BlockState, List<Integer>> blocks) {
        ListTag list = new ListTag();
        blocks.forEach((state, positions) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)state));
            tag.m_128408_("blocks", positions);
            list.add((Object)tag);
        });
        vehicleCard.m_41784_().m_128365_("blocks", (Tag)list);
    }

    public static Map<BlockState, List<BlockPos>> getBlocks(ItemStack vehicleCard, BlockPos minPos) {
        HashMap<BlockState, List<BlockPos>> result = new HashMap<BlockState, List<BlockPos>>();
        CompoundTag compoundTag = vehicleCard.m_41783_();
        if (compoundTag != null) {
            ListTag list = compoundTag.m_128437_("blocks", 10);
            for (Tag tag : list) {
                CompoundTag c = (CompoundTag)tag;
                BlockState state = NbtUtils.m_129241_((CompoundTag)c.m_128469_("state"));
                int[] blocks = c.m_128465_("blocks");
                List blockPosList = Arrays.stream(blocks).mapToObj(i -> VehicleCard.convertIntToPos(minPos, i)).collect(Collectors.toList());
                result.put(state, blockPosList);
            }
        }
        return result;
    }

    public static int convertPosToInt(BlockPos min, BlockPos current) {
        int dx = current.m_123341_() - min.m_123341_();
        int dy = current.m_123342_() - min.m_123342_();
        int dz = current.m_123343_() - min.m_123343_();
        return dx << 20 | dy << 10 | dz;
    }

    public static BlockPos convertIntToPos(BlockPos min, int current) {
        return new BlockPos(min.m_123341_() + (current >> 20 & 0x3F), min.m_123342_() + (current >> 10 & 0x3F), min.m_123343_() + (current & 0x3F));
    }
}

