/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.scanner.network;

import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.RLE;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.blocks.SupportBlock;
import mcjty.rftoolsbuilder.shapes.RenderData;
import mcjty.rftoolsbuilder.shapes.ShapeID;
import mcjty.rftoolsbuilder.shapes.ShapeRenderer;
import mcjty.rftoolsbuilder.shapes.StatePalette;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketReturnShapeData {
    private final ShapeID id;
    private final RLE positions;
    private final StatePalette statePalette;
    private final int count;
    private final int offsetY;
    private final String msg;
    private final BlockPos dimension;

    public void toBytes(FriendlyByteBuf buf) {
        this.id.toBytes(buf);
        buf.writeInt(this.count);
        buf.writeInt(this.offsetY);
        NetworkTools.writeStringUTF8((FriendlyByteBuf)buf, (String)this.msg);
        buf.m_130064_(this.dimension);
        if (this.statePalette == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.statePalette.getPalette().size());
            for (BlockState state : this.statePalette.getPalette()) {
                BlockState blockState = state;
                if (blockState.m_60734_().getRegistryName() == null) {
                    blockState = Blocks.f_50069_.m_49966_();
                }
                buf.m_130070_(blockState.m_60734_().getRegistryName().toString());
            }
        }
        if (this.positions == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.positions.getData().length);
            buf.writeBytes(this.positions.getData());
        }
    }

    public PacketReturnShapeData(FriendlyByteBuf buf) {
        int size;
        this.id = new ShapeID(buf);
        this.count = buf.readInt();
        this.offsetY = buf.readInt();
        this.msg = NetworkTools.readStringUTF8((FriendlyByteBuf)buf);
        this.dimension = buf.m_130135_();
        if (size == 0) {
            this.statePalette = null;
        } else {
            this.statePalette = new StatePalette();
            for (size = buf.readInt(); size > 0; --size) {
                String r = buf.m_130136_(Short.MAX_VALUE);
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(r));
                this.statePalette.add(block.m_49966_());
            }
        }
        size = buf.readInt();
        if (size == 0) {
            this.positions = null;
        } else {
            this.positions = new RLE();
            byte[] data = new byte[size];
            buf.readBytes(data);
            this.positions.setData(data);
        }
    }

    public PacketReturnShapeData(ShapeID id, RLE positions, StatePalette statePalette, BlockPos dimension, int count, int offsetY, String msg) {
        this.id = id;
        this.positions = positions;
        this.statePalette = statePalette;
        this.dimension = dimension;
        this.count = count;
        this.offsetY = offsetY;
        this.msg = msg;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int dx = this.dimension.m_123341_();
            int dy = this.dimension.m_123342_();
            int dz = this.dimension.m_123343_();
            RLE rle = this.positions;
            RenderData.RenderPlane plane = null;
            if (rle != null) {
                BlockState dummy = ((SupportBlock)BuilderModule.SUPPORT.get()).m_49966_();
                rle.reset();
                int oy = this.offsetY;
                int y = oy - dy / 2;
                RenderData.RenderStrip[] strips = new RenderData.RenderStrip[dx];
                for (int ox = 0; ox < dx; ++ox) {
                    RenderData.RenderStrip strip;
                    int x = ox - dx / 2;
                    strips[ox] = strip = new RenderData.RenderStrip(x);
                    for (int oz = 0; oz < dz; ++oz) {
                        int data = rle.read();
                        if (data < 255) {
                            if (data == 0) {
                                strip.add(dummy);
                                continue;
                            }
                            strip.add(this.statePalette.getPalette().get(--data));
                            continue;
                        }
                        strip.add(null);
                    }
                    strip.close();
                    plane = new RenderData.RenderPlane(strips, y, oy, -dz / 2, this.count);
                }
            }
            ShapeRenderer.setRenderData(this.id, plane, this.offsetY, dy, this.msg);
        });
        ctx.setPacketHandled(true);
    }
}

