/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldProjectorTileEntity;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShieldingBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty BLOCKED_ITEMS = BooleanProperty.m_61465_((String)"bi");
    public static final BooleanProperty BLOCKED_PASSIVE = BooleanProperty.m_61465_((String)"bp");
    public static final BooleanProperty BLOCKED_HOSTILE = BooleanProperty.m_61465_((String)"bh");
    public static final BooleanProperty BLOCKED_PLAYERS = BooleanProperty.m_61465_((String)"bplay");
    public static final BooleanProperty DAMAGE_ITEMS = BooleanProperty.m_61465_((String)"di");
    public static final BooleanProperty DAMAGE_PASSIVE = BooleanProperty.m_61465_((String)"dp");
    public static final BooleanProperty DAMAGE_HOSTILE = BooleanProperty.m_61465_((String)"dh");
    public static final BooleanProperty DAMAGE_PLAYERS = BooleanProperty.m_61465_((String)"dplay");
    public static final BooleanProperty FLAG_OPAQUE = BooleanProperty.m_61465_((String)"opaque");
    public static final EnumProperty<ShieldRenderingMode> RENDER_MODE = EnumProperty.m_61587_((String)"render", ShieldRenderingMode.class);
    public static final VoxelShape COLLISION_SHAPE = Shapes.m_83048_((double)0.002, (double)0.002, (double)0.002, (double)0.998, (double)0.998, (double)0.998);

    public ShieldingBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60955_().m_60924_((state, world, pos) -> false).m_60913_(-1.0f, 3600000.0f).m_60993_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BLOCKED_ITEMS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMAGE_ITEMS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FLAG_OPAQUE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ShieldingTileEntity(pPos, pState);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BLOCKED_ITEMS, BLOCKED_HOSTILE, BLOCKED_PASSIVE, BLOCKED_PLAYERS, DAMAGE_ITEMS, DAMAGE_HOSTILE, DAMAGE_PASSIVE, DAMAGE_PLAYERS, FLAG_OPAQUE, RENDER_MODE});
    }

    public int m_7753_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)FLAG_OPAQUE) != false ? 0 : 255;
    }

    @Nonnull
    public RenderShape m_7514_(BlockState state) {
        return state.m_61143_(RENDER_MODE) == ShieldRenderingMode.INVISIBLE ? RenderShape.INVISIBLE : RenderShape.MODEL;
    }

    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return super.m_7749_(state, worldIn, pos);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        BlockState mimic;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.m_60651_(world, pos, context);
        }
        if (state.m_61143_(RENDER_MODE) == ShieldRenderingMode.INVISIBLE) {
            return Shapes.m_83040_();
        }
        return super.m_5940_(state, world, pos, context);
    }

    @Nonnull
    public VoxelShape m_6079_(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos) {
        BlockState mimic;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.m_60771_(world, pos, CollisionContext.m_82749_());
        }
        if (state.m_61143_(RENDER_MODE) == ShieldRenderingMode.INVISIBLE) {
            return Shapes.m_83040_();
        }
        return super.m_6079_(state, world, pos);
    }

    @Nonnull
    public VoxelShape m_7952_(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos) {
        BlockState mimic;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShieldingTileEntity && (mimic = ((ShieldingTileEntity)te).getMimic()) != null) {
            return mimic.m_60768_(world, pos);
        }
        return super.m_7952_(state, world, pos);
    }

    public static boolean isHostile(Entity entity) {
        return entity instanceof Enemy;
    }

    public static boolean isPassive(Entity entity) {
        if (entity instanceof Enemy) {
            return false;
        }
        if (entity instanceof Player) {
            return false;
        }
        return entity instanceof Mob;
    }

    public static boolean isItem(Entity entity) {
        return !(entity instanceof LivingEntity);
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ctxt = (EntityCollisionContext)context;
            Entity entity = ctxt.m_193113_();
            if (((Boolean)state.m_61143_((Property)BLOCKED_HOSTILE)).booleanValue() && ShieldingBlock.isHostile(entity)) {
                if (this.checkEntityCD(world, pos, "hostile")) {
                    return COLLISION_SHAPE;
                }
                return Shapes.m_83040_();
            }
            if (((Boolean)state.m_61143_((Property)BLOCKED_PASSIVE)).booleanValue() && ShieldingBlock.isPassive(entity)) {
                if (this.checkEntityCD(world, pos, "animal")) {
                    return COLLISION_SHAPE;
                }
                return Shapes.m_83040_();
            }
            if (((Boolean)state.m_61143_((Property)BLOCKED_PLAYERS)).booleanValue() && entity instanceof Player) {
                if (this.checkPlayerCD(world, pos, (Player)entity)) {
                    return COLLISION_SHAPE;
                }
                return Shapes.m_83040_();
            }
            if (((Boolean)state.m_61143_((Property)BLOCKED_ITEMS)).booleanValue() && ShieldingBlock.isItem(entity)) {
                if (this.checkEntityCD(world, pos, "item")) {
                    return COLLISION_SHAPE;
                }
                return Shapes.m_83040_();
            }
        }
        return Shapes.m_83040_();
    }

    private boolean checkEntityCD(BlockGetter world, BlockPos pos, String filterName) {
        ShieldProjectorTileEntity projector = this.getShieldProjector(world, pos);
        if (projector != null) {
            List<ShieldFilter> filters = projector.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!filterName.equals(filter.getFilterName())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    private boolean checkPlayerCD(BlockGetter world, BlockPos pos, Player entity) {
        ShieldProjectorTileEntity projector = this.getShieldProjector(world, pos);
        if (projector != null) {
            List<ShieldFilter> filters = projector.getFilters();
            for (ShieldFilter filter : filters) {
                if ("default".equals(filter.getFilterName())) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!"player".equals(filter.getFilterName())) continue;
                PlayerFilter playerFilter = (PlayerFilter)filter;
                String name = playerFilter.getName();
                if (name == null || name.isEmpty()) {
                    return (filter.getAction() & 1) != 0;
                }
                if (!name.equals(entity.m_7755_().getString())) continue;
                return (filter.getAction() & 1) != 0;
            }
        }
        return false;
    }

    public boolean m_6104_(@Nonnull BlockState state, BlockState adjacentBlockState, @Nonnull Direction side) {
        return adjacentBlockState.m_60734_() == this ? true : super.m_6104_(state, adjacentBlockState, side);
    }

    public void m_7892_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Entity entity) {
        if (!(entity instanceof LivingEntity) && !((Boolean)state.m_61143_((Property)BLOCKED_ITEMS)).booleanValue()) {
            entity.m_6034_(entity.m_20185_(), entity.m_20186_() - 1.0, entity.m_20189_());
        }
        this.handleDamage(state, world, pos, entity);
    }

    @Nullable
    private ShieldProjectorTileEntity getShieldProjector(BlockGetter world, BlockPos shieldingPos) {
        BlockEntity tileEntity;
        BlockPos projectorPos;
        BlockEntity te = world.m_7702_(shieldingPos);
        if (te instanceof ShieldingTileEntity && (projectorPos = ((ShieldingTileEntity)te).getShieldProjector()) != null && (tileEntity = world.m_7702_(projectorPos)) instanceof ShieldProjectorTileEntity) {
            return (ShieldProjectorTileEntity)tileEntity;
        }
        return null;
    }

    public void handleDamage(BlockState state, Level world, BlockPos pos, Entity entity) {
        ShieldProjectorTileEntity projector;
        Boolean dmgHostile = (Boolean)state.m_61143_((Property)DAMAGE_HOSTILE);
        Boolean dmgPassive = (Boolean)state.m_61143_((Property)DAMAGE_PASSIVE);
        Boolean dmgPlayer = (Boolean)state.m_61143_((Property)DAMAGE_PLAYERS);
        Boolean dmgItems = (Boolean)state.m_61143_((Property)DAMAGE_ITEMS);
        if (!dmgHostile.booleanValue() && !dmgPassive.booleanValue() && !dmgPlayer.booleanValue() && !dmgItems.booleanValue() || world.f_46443_ || world.m_46467_() % 10L != 0L) {
            return;
        }
        int xCoord = pos.m_123341_();
        int yCoord = pos.m_123342_();
        int zCoord = pos.m_123343_();
        AABB beamBox = new AABB((double)xCoord - 0.4, (double)yCoord - 0.4, (double)zCoord - 0.4, (double)xCoord + 1.4, (double)yCoord + 2.0, (double)zCoord + 1.4);
        if (entity.m_142469_().m_82381_(beamBox) && (projector = this.getShieldProjector((BlockGetter)world, pos)) != null) {
            if (dmgItems.booleanValue() && entity instanceof ItemEntity) {
                if (this.checkEntityDamage(projector, "item")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgHostile.booleanValue() && ShieldingBlock.isHostile(entity)) {
                if (this.checkEntityDamage(projector, "hostile")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgPassive.booleanValue() && ShieldingBlock.isPassive(entity)) {
                if (this.checkEntityDamage(projector, "animal")) {
                    projector.applyDamageToEntity(entity);
                }
            } else if (dmgPlayer.booleanValue() && entity instanceof Player && this.checkPlayerDamage(projector, (Player)entity)) {
                projector.applyDamageToEntity(entity);
            }
        }
    }

    private boolean checkEntityDamage(@Nonnull ShieldProjectorTileEntity shieldTileEntity, String filterName) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!filterName.equals(filter.getFilterName())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }

    private boolean checkPlayerDamage(@Nonnull ShieldProjectorTileEntity shieldTileEntity, Player entity) {
        List<ShieldFilter> filters = shieldTileEntity.getFilters();
        for (ShieldFilter filter : filters) {
            if ("default".equals(filter.getFilterName())) {
                return (filter.getAction() & 2) != 0;
            }
            if (!"player".equals(filter.getFilterName())) continue;
            PlayerFilter playerFilter = (PlayerFilter)filter;
            String name = playerFilter.getName();
            if (name == null || name.isEmpty()) {
                return (filter.getAction() & 2) != 0;
            }
            if (!name.equals(entity.m_7755_().getString())) continue;
            return (filter.getAction() & 2) != 0;
        }
        return false;
    }
}

