/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.shapes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.rftoolsbuilder.modules.scanner.ScannerConfiguration;
import mcjty.rftoolsbuilder.shapes.Scan;
import mcjty.rftoolsbuilder.shapes.ScanExtraData;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ScanDataManager
extends AbstractWorldData<ScanDataManager> {
    private static final String SCANDATA_NETWORK_NAME = "RFToolsScanData";
    private int lastId = 0;
    private final Map<Integer, Scan> scans = new HashMap<Integer, Scan>();
    private final Map<Integer, ScanExtraData> scanData = new HashMap<Integer, ScanExtraData>();

    public ScanDataManager() {
    }

    public ScanDataManager(CompoundTag tag) {
        this.scans.clear();
        ListTag lst = tag.m_128437_("scans", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            int id = tc.m_128451_("scan");
            Scan scan = new Scan();
            scan.readFromNBT(tc);
            this.scans.put(id, scan);
        }
        this.lastId = tag.m_128451_("lastId");
    }

    public void save(Level w, int scanId) {
        ServerLevel world = LevelTools.getOverworld((Level)w);
        File dataDir = null;
        dataDir.mkdirs();
        File file = new File(dataDir, "scan" + scanId);
        Scan scan = this.getOrCreateScan(scanId);
        CompoundTag tc = new CompoundTag();
        scan.writeToNBTExternal(tc);
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file));){
            NbtIo.m_128947_((CompoundTag)tc, (OutputStream)dataoutputstream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error writing to file 'scan" + scan + "'!", e);
        }
        this.save();
    }

    public ScanExtraData getExtraData(int id) {
        ScanExtraData data = this.scanData.get(id);
        if (data == null) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        } else if (data.getBirthTime() + (long)((Integer)ScannerConfiguration.ticksPerLocatorScan.get() * 100) < System.currentTimeMillis()) {
            data = new ScanExtraData();
            this.scanData.put(id, data);
        }
        return data;
    }

    public static ScanDataManager get(Level world) {
        return (ScanDataManager)ScanDataManager.getData((Level)world, ScanDataManager::new, ScanDataManager::new, (String)SCANDATA_NETWORK_NAME);
    }

    @Nonnull
    public Scan getOrCreateScan(int id) {
        Scan scan = this.scans.get(id);
        if (scan == null) {
            scan = new Scan();
            this.scans.put(id, scan);
        }
        return scan;
    }

    @Nonnull
    public Scan loadScan(Level w, int id) {
        ServerLevel world = LevelTools.getOverworld((Level)w);
        Scan scan = this.scans.get(id);
        if (scan == null || scan.getDataInt() == null) {
            if (scan == null) {
                scan = new Scan();
            }
            File dataDir = null;
            dataDir.mkdirs();
            File file = new File(dataDir, "scan" + id);
            if (file.exists()) {
                try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));){
                    CompoundTag tag = NbtIo.m_128939_((InputStream)datainputstream);
                    scan.readFromNBTExternal(tag);
                }
                catch (IOException e) {
                    Logging.log((String)("Error reading scan file for id: " + id));
                }
            }
        }
        return scan;
    }

    public static void listScans(Player sender) {
        ScanDataManager scans = ScanDataManager.get(sender.m_20193_());
        for (Map.Entry<Integer, Scan> entry : scans.scans.entrySet()) {
            Integer scanid = entry.getKey();
            scans.loadScan(sender.m_20193_(), scanid);
            Scan scan = entry.getValue();
            BlockPos dim = scan.getDataDim();
            if (dim == null) {
                sender.m_6352_((Component)new TextComponent(ChatFormatting.YELLOW + "Scan: " + ChatFormatting.WHITE + scanid + ChatFormatting.RED + "   Invalid"), Util.f_137441_);
                continue;
            }
            sender.m_6352_((Component)new TextComponent(ChatFormatting.YELLOW + "Scan: " + ChatFormatting.WHITE + scanid + ChatFormatting.YELLOW + "   Dim: " + ChatFormatting.WHITE + dim.m_123341_() + "," + dim.m_123342_() + "," + dim.m_123343_() + ChatFormatting.YELLOW + "   Size: " + ChatFormatting.WHITE + scan.getRledata().length + " bytes"), Util.f_137441_);
        }
    }

    public int newScan(Level world) {
        ++this.lastId;
        this.save();
        return this.lastId;
    }

    public CompoundTag m_7176_(CompoundTag tagCompound) {
        ListTag lst = new ListTag();
        for (Map.Entry<Integer, Scan> entry : this.scans.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128405_("scan", entry.getKey().intValue());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("scans", (Tag)lst);
        tagCompound.m_128405_("lastId", this.lastId);
        return tagCompound;
    }
}

