/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.core.ModDataGeneration;
import com.affehund.voidtotem.core.ModUtils;
import com.affehund.voidtotem.core.VoidTotemConfig;
import com.affehund.voidtotem.core.network.PacketHandler;
import com.affehund.voidtotem.core.network.TotemEffectPacket;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="voidtotem")
public class VoidTotem {
    public static final Logger LOGGER = LogManager.getLogger((String)"Void Totem");
    public static VoidTotem INSTANCE;
    final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    final IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
    public static final DeferredRegister<Item> ITEMS;
    public static final RegistryObject<Item> VOID_TOTEM_ITEM;

    public VoidTotem() {
        INSTANCE = this;
        LOGGER.debug("Loading up {}!", (Object)"Void Totem");
        if (ModUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
            LOGGER.debug("Enqueued IMC to {}", (Object)"curios");
        }
        this.modEventBus.addListener(this::gatherData);
        ITEMS.register(this.modEventBus);
        this.forgeEventBus.register((Object)this);
        this.forgeEventBus.addListener(this::livingHurt);
        this.forgeEventBus.addListener(this::livingFall);
        this.forgeEventBus.addListener(this::playerTick);
        this.forgeEventBus.addGenericListener(ItemStack.class, this::attachCaps);
        PacketHandler.registerMessages();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)VoidTotemConfig.COMMON_CONFIG_SPEC, "voidtotem-common.toml");
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack;
        Item item;
        if (ModUtils.isModLoaded("curios") && (item = (stack = (ItemStack)event.getObject()).m_41720_()).getRegistryName() != null && VoidTotem.isVoidTotemOrTotem(stack)) {
            LOGGER.debug("Attached Curios Capability to {}", (Object)item.getRegistryName());
            event.addCapability(new ResourceLocation("voidtotem", item.getRegistryName().m_135815_() + "_curios"), new ICapabilityProvider(){
                final ICurio curio = new ICurio(){

                    public boolean canRightClickEquip() {
                        return true;
                    }

                    public ItemStack getStack() {
                        return stack;
                    }
                };

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> this.curio));
                }
            });
        }
    }

    @SubscribeEvent
    public void loadLootTables(LootTableLoadEvent event) {
        if (((Boolean)VoidTotemConfig.COMMON_CONFIG.ADD_END_CITY_TREASURE.get()).booleanValue() && event.getName().equals((Object)ModConstants.LOCATION_END_CITY_TREASURE)) {
            LOGGER.debug("Injecting loottable {} from {}", (Object)ModConstants.LOCATION_END_CITY_TREASURE.toString(), (Object)"voidtotem");
            event.getTable().addPool(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ModConstants.LOCATION_END_CITY_TREASURE_INJECTION)).name("voidtotem_injection").m_79082_());
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new ModDataGeneration.RecipeGen(generator));
            ModDataGeneration.BlockTagsGen blockTagsProvider = new ModDataGeneration.BlockTagsGen(generator, "voidtotem", existingFileHelper);
            generator.m_123914_((DataProvider)new ModDataGeneration.ItemTagsGen(generator, blockTagsProvider, "voidtotem", existingFileHelper));
            generator.m_123914_((DataProvider)new ModDataGeneration.AdvancementGen(generator));
            generator.m_123914_((DataProvider)new ModDataGeneration.LootTableGen(generator));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new ModDataGeneration.LanguageGen(generator, "de_de"));
            generator.m_123914_((DataProvider)new ModDataGeneration.LanguageGen(generator, "en_us"));
            generator.m_123914_((DataProvider)new ModDataGeneration.LanguageGen(generator, "ru_ru"));
            generator.m_123914_((DataProvider)new ModDataGeneration.ItemModelGen(generator, "voidtotem", existingFileHelper));
        }
    }

    private void livingFall(LivingFallEvent event) {
        ServerPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getPersistentData().m_128471_("voidtotem_living_falling")) {
            player.f_8906_.f_9737_ = 0;
            event.setDamageMultiplier(0.0f);
            player.getPersistentData().m_128379_("voidtotem_living_falling", false);
            event.setCanceled(true);
        }
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            BlockPos pos = player2.m_142538_();
            long lastPosLong = player2.getPersistentData().m_128454_("voidtotem_last_block_pos");
            BlockPos lastPos = BlockPos.m_122022_((long)lastPosLong);
            if (player2.f_19853_.m_8055_(pos.m_7495_()).m_60815_() && !lastPos.equals((Object)pos)) {
                player2.getPersistentData().m_128356_("voidtotem_last_block_pos", pos.m_121878_());
            }
            if (player2.getPersistentData().m_128471_("voidtotem_living_falling")) {
                player2.f_8906_.f_9737_ = 0;
                if (player2.m_20069_() || player2.m_150110_().f_35935_ || player2.m_150110_().f_35936_ || player2.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50033_) {
                    player2.getPersistentData().m_128379_("voidtotem_living_falling", false);
                }
            }
        }
    }

    private void livingHurt(LivingHurtEvent event) {
        Entity entity = event.getEntity();
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (((ArrayList)VoidTotemConfig.COMMON_CONFIG.BLACKLISTED_DIMENSIONS.get()).contains(entity.f_19853_.m_46472_().m_135782_().toString())) {
            return;
        }
        if (event.getSource() != DamageSource.f_19317_ || entity.m_20186_() > -64.0) {
            return;
        }
        if (event.getAmount() < event.getEntityLiving().m_21223_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.f_8906_.f_9737_ = 0;
            ItemStack itemstack = null;
            if (!((Boolean)VoidTotemConfig.COMMON_CONFIG.NEEDS_TOTEM.get()).booleanValue()) {
                itemstack = ItemStack.f_41583_;
            }
            if (ModUtils.isModLoaded("curios") && itemstack == null) {
                ItemStack curiosVanillaTotemStack;
                InteractionHand[] curiosVoidTotemStack = ModUtils.findCuriosItem((Item)VOID_TOTEM_ITEM.get(), (LivingEntity)player);
                ItemStack itemStack = curiosVanillaTotemStack = (Boolean)VoidTotemConfig.COMMON_CONFIG.ALLOW_TOTEM_OF_UNDYING.get() != false ? ModUtils.findCuriosItem(Items.f_42747_, (LivingEntity)player) : ItemStack.f_41583_;
                if (!curiosVoidTotemStack.m_41619_()) {
                    itemstack = VoidTotem.copyAndRemoveItemStack((ItemStack)curiosVoidTotemStack, player);
                } else if (!curiosVanillaTotemStack.m_41619_()) {
                    itemstack = VoidTotem.copyAndRemoveItemStack(curiosVanillaTotemStack, player);
                }
            }
            if (((Boolean)VoidTotemConfig.COMMON_CONFIG.USE_TOTEM_FROM_INVENTORY.get()).booleanValue() && itemstack == null) {
                for (ItemStack itemStack : player.m_150109_().f_35974_) {
                    if (!VoidTotem.isVoidTotemOrTotem(itemStack)) continue;
                    itemstack = VoidTotem.copyAndRemoveItemStack(itemStack, player);
                    break;
                }
            }
            if (itemstack == null) {
                for (InteractionHand hand : InteractionHand.values()) {
                    ItemStack stack = player.m_21120_(hand);
                    if (!VoidTotem.isVoidTotemOrTotem(stack)) continue;
                    itemstack = VoidTotem.copyAndRemoveItemStack(stack, player);
                    break;
                }
            }
            if (itemstack != null) {
                if (player.f_8906_.f_9766_ != null) {
                    return;
                }
                if (player.m_20160_()) {
                    player.m_20153_();
                }
                player.m_8127_();
                long lastBlockPos = player.getPersistentData().m_128454_("voidtotem_last_block_pos");
                BlockPos teleportPos = BlockPos.m_122022_((long)lastBlockPos);
                boolean teleportedToBlock = false;
                for (int i = 0; i < 16; ++i) {
                    double z;
                    double y;
                    double x = (double)teleportPos.m_123341_() + (player.m_21187_().nextDouble() - 0.5) * 4.0;
                    if (!player.m_20984_(x, y = Mth.m_14008_((double)(player.m_21187_().nextInt() * player.f_19853_.m_141928_()), (double)0.0, (double)(player.f_19853_.m_141928_() - 1)), z = (double)teleportPos.m_123343_() + (player.m_21187_().nextDouble() - 0.5) * 4.0, true)) continue;
                    teleportedToBlock = true;
                    break;
                }
                if (!teleportedToBlock) {
                    player.m_6021_((double)teleportPos.m_123341_(), (double)((Integer)VoidTotemConfig.COMMON_CONFIG.TELEPORT_HEIGHT.get()).intValue(), (double)teleportPos.m_123343_());
                    player.f_8906_.f_9737_ = 0;
                }
                event.setCanceled(true);
                player.getPersistentData().m_128379_("voidtotem_living_falling", true);
                PacketHandler.sendToPlayer(new TotemEffectPacket(itemstack, (Entity)player), player);
                PacketHandler.sendToAllTracking(new TotemEffectPacket(itemstack, (Entity)player), player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (VoidTotem.isVoidTotemOrTotem(stack) && ((Boolean)VoidTotemConfig.COMMON_CONFIG.SHOW_TOTEM_TOOLTIP.get()).booleanValue()) {
            event.getToolTip().add(new TranslatableComponent("tooltip.voidtotem.totem_of_void_undying").m_130940_(ChatFormatting.GREEN));
        }
    }

    public static boolean isVoidTotemOrTotem(ItemStack stack) {
        Item item = stack.m_41720_();
        boolean isVoidTotem = item == VOID_TOTEM_ITEM.get();
        boolean isTotemOfUndying = (Boolean)VoidTotemConfig.COMMON_CONFIG.ALLOW_TOTEM_OF_UNDYING.get() != false && item == Items.f_42747_;
        return isVoidTotem || isTotemOfUndying;
    }

    private static ItemStack copyAndRemoveItemStack(ItemStack itemStack, ServerPlayer player) {
        ItemStack itemStackCopy = itemStack.m_41777_();
        if (!itemStack.m_41619_()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
            CriteriaTriggers.f_10551_.m_74431_(player, itemStack);
        }
        itemStack.m_41774_(1);
        return itemStackCopy;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playActivateAnimation(ItemStack stack, Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91061_.m_107332_(entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
        assert (mc.f_91073_ != null);
        mc.f_91073_.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, entity.m_5720_(), 1.0f, 1.0f, false);
        if (entity == mc.f_91074_) {
            mc.f_91063_.m_109113_(stack);
        }
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"voidtotem");
        VOID_TOTEM_ITEM = ITEMS.register("totem_of_void_undying", () -> new Item(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40757_).m_41497_(Rarity.UNCOMMON)));
    }
}

