/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.voidtotem.core;

import com.affehund.voidtotem.ModConstants;
import com.affehund.voidtotem.VoidTotem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.UsedTotemTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDataGeneration {
    private static final Logger DATAGEN_LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final Tag.Named<Item> CURIOS_CHARM = ModDataGeneration.modTag("charm", "curios");

    private static Tag.Named<Item> modTag(String name, String modID) {
        return ItemTags.m_13194_((String)(modID + ":" + name));
    }

    public static class LootTableGen
    extends LootTableProvider {
        private final DataGenerator generator;

        public LootTableGen(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
            this.generator = dataGeneratorIn;
        }

        public void m_6865_(@Nonnull HashCache cache) {
            HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
            LootPool.Builder voidtotem_loot_builder = LootPool.m_79043_().name("main").m_6509_(LootItemRandomChanceCondition.m_81927_((float)0.33f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get())).m_79707_(1));
            tables.put(ModConstants.LOCATION_END_CITY_TREASURE_INJECTION, LootTable.m_79147_().m_79161_(voidtotem_loot_builder).m_79167_());
            this.writeLootTables(cache, tables);
        }

        private void writeLootTables(HashCache cache, Map<ResourceLocation, LootTable> tables) {
            Path outputFolder = this.generator.m_123916_();
            tables.forEach((key, lootTable) -> {
                Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
                try {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
                    DATAGEN_LOGGER.debug("Creating loot table {}", (Object)key.m_135815_());
                }
                catch (IOException e) {
                    DATAGEN_LOGGER.error("Couldn't create loot table {}", (Object)key.m_135815_(), (Object)e);
                }
            });
        }
    }

    public static class AdvancementGen
    extends AdvancementProvider {
        private final DataGenerator generator;

        public AdvancementGen(DataGenerator generatorIn) {
            super(generatorIn);
            this.generator = generatorIn;
        }

        private void registerAdvancements(Consumer<Advancement> consumer) {
            Advancement.Builder.m_138353_().m_138398_(Advancement.Builder.m_138353_().m_138403_(new ResourceLocation("adventure/totem_of_undying"))).m_138371_((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get(), (Component)new TranslatableComponent("advancements.voidtotem.adventure.totem_of_void_undying.title"), (Component)new TranslatableComponent("advancements.voidtotem.adventure.totem_of_void_undying.description"), (ResourceLocation)null, FrameType.GOAL, true, true, false).m_138386_("used_totem", (CriterionTriggerInstance)UsedTotemTrigger.TriggerInstance.m_74452_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get()))).m_138389_(consumer, "adventure/totem_of_void_undying");
        }

        public void m_6865_(@Nullable HashCache cache) {
            Path outputFolder = this.generator.m_123916_();
            Consumer<Advancement> consumer = advancement -> {
                Path path = outputFolder.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
                try {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path);
                    DATAGEN_LOGGER.debug("Creating advancement {}", (Object)advancement.m_138327_());
                }
                catch (IOException e) {
                    DATAGEN_LOGGER.error("Couldn't create advancement {}", (Object)path, (Object)e);
                }
            };
            this.registerAdvancements(consumer);
        }
    }

    public static final class ItemTagsGen
    extends ItemTagsProvider {
        public ItemTagsGen(DataGenerator gen, BlockTagsProvider provider, String modID, ExistingFileHelper existingFileHelper) {
            super(gen, provider, modID, existingFileHelper);
        }

        protected void m_6577_() {
            this.m_126548_(CURIOS_CHARM).m_126582_((Object)((Item)VoidTotem.VOID_TOTEM_ITEM.get())).m_126582_((Object)Items.f_42747_);
        }
    }

    public static final class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(DataGenerator generatorIn, String modId, ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }
    }

    public static final class RecipeGen
    extends RecipeProvider {
        public RecipeGen(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)VoidTotem.VOID_TOTEM_ITEM.get())).m_126130_("cec").m_126130_("dtd").m_126130_(" e ").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42730_).m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('d'), (ItemLike)Items.f_42616_).m_126127_(Character.valueOf('t'), (ItemLike)Items.f_42747_).m_142284_("has_chorus_fruit", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42730_)).m_142284_("has_ender_eye", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42545_)).m_142284_("has_emerald", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42616_)).m_142284_("has_totem", (CriterionTriggerInstance)RecipeGen.m_125977_((ItemLike)Items.f_42747_)).m_176498_(consumer);
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        private final Set<Item> blacklist = new HashSet<Item>();

        public ItemModelGen(DataGenerator gen, String modid, ExistingFileHelper existingFileHelper) {
            super(gen, modid, existingFileHelper);
        }

        protected void registerModels() {
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null || !"voidtotem".equals(id.m_135827_()) || this.blacklist.contains(item)) continue;
                if (item instanceof BlockItem) {
                    return;
                }
                this.defaultItem(id, item);
            }
        }

        protected void defaultItem(ResourceLocation id, Item item) {
            ((ItemModelBuilder)this.withExistingParent(id.m_135815_(), "item/generated")).texture("layer0", new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_()));
            DATAGEN_LOGGER.debug("Generated item model for: " + item.getRegistryName());
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public LanguageGen(DataGenerator gen, String locale) {
            super(gen, "voidtotem", locale);
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.m_6055_().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem der Unsterblichkeit in der Leere");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Lege diese Totem in deine Haupt-/Nebenhand, um zu verhindern, dass du stirbst, wenn du in die Leere f\u00c3\u00a4llst.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Post mortem 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Benutze ein Totem der Unsterblichkeit in der Leere, um dem Tod, wenn du in die Leere f\u00c3\u00a4llst, von der Schippe zu springen");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)VoidTotem.VOID_TOTEM_ITEM.get(), "Totem of Void Undying");
                    this.add("tooltip.voidtotem.totem_of_void_undying", "Put this totem in your main-/offhand to prevent dying if you fall in the void.");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.title", "Postmortal 2");
                    this.add("advancements.voidtotem.adventure.totem_of_void_undying.description", "Use a Totem of Void Undying to cheat death when falling in the void");
                }
            }
        }
    }
}

