/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.fluid;

import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public final class FluidStack {
    private static final FluidStack EMPTY = FluidStack.create(Fluids.f_76191_, 0L);
    private long amount;
    @Nullable
    private CompoundTag tag;
    private Supplier<Fluid> fluid;

    private FluidStack(Supplier<Fluid> fluid, long amount, CompoundTag tag) {
        this.fluid = Objects.requireNonNull(fluid);
        this.amount = amount;
        this.tag = tag == null ? null : tag.m_6426_();
    }

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(Fluid fluid, long amount, @Nullable CompoundTag tag) {
        return FluidStack.create(() -> fluid, amount, tag);
    }

    public static FluidStack create(Fluid fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(Supplier<Fluid> fluid, long amount, @Nullable CompoundTag tag) {
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack create(Supplier<Fluid> fluid, long amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, long amount) {
        return FluidStack.create(stack.getRawFluidSupplier(), amount, stack.getTag());
    }

    public static long bucketAmount() {
        return FluidStackHooks.bucketAmount();
    }

    public final Fluid getFluid() {
        return this.isEmpty() ? Fluids.f_76191_ : this.getRawFluid();
    }

    @Nullable
    public final Fluid getRawFluid() {
        return this.fluid.get();
    }

    public final Supplier<Fluid> getRawFluidSupplier() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getRawFluid() == Fluids.f_76191_ || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(@Nullable CompoundTag tag) {
        this.tag = tag;
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    @Nullable
    public CompoundTag getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.m_128469_(childName);
    }

    public CompoundTag getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        CompoundTag child = this.tag.m_128469_(childName);
        if (!this.tag.m_128425_(childName, 10)) {
            this.tag.m_128365_(childName, (Tag)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.m_128473_(childName);
        }
    }

    public Component getName() {
        return FluidStackHooks.getName(this);
    }

    public String getTranslationKey() {
        return FluidStackHooks.getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluid, this.amount, this.tag);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + Long.hashCode(this.amount);
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidStackEqual((FluidStack)o);
    }

    public boolean isFluidStackEqual(FluidStack other) {
        return this.getFluid() == other.getFluid() && this.getAmount() == other.getAmount() && this.isTagEqual(other);
    }

    private boolean isTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : other.tag != null && this.tag.equals((Object)other.tag);
    }

    public static FluidStack read(FriendlyByteBuf buf) {
        return FluidStackHooks.read(buf);
    }

    public static FluidStack read(CompoundTag tag) {
        return FluidStackHooks.read(tag);
    }

    public void write(FriendlyByteBuf buf) {
        FluidStackHooks.write(this, buf);
    }

    public CompoundTag write(CompoundTag tag) {
        return FluidStackHooks.write(this, tag);
    }
}

