/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform.forge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraftforge.eventbus.api.IEventBus;

public final class EventBuses {
    private static final Map<String, IEventBus> EVENT_BUS_MAP = new HashMap<String, IEventBus>();
    private static final Map<String, List<Consumer<IEventBus>>> ON_REGISTERED = new HashMap<String, List<Consumer<IEventBus>>>();

    private EventBuses() {
    }

    public static void registerModEventBus(String modId, IEventBus bus) {
        if (EVENT_BUS_MAP.putIfAbsent(modId, bus) != null) {
            throw new IllegalStateException("Can't register event bus for mod '" + modId + "' because it was previously registered!");
        }
        for (Consumer runnable : ON_REGISTERED.getOrDefault(modId, Collections.emptyList())) {
            runnable.accept(bus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRegistered(String modId, Consumer<IEventBus> busConsumer) {
        if (EVENT_BUS_MAP.containsKey(modId)) {
            busConsumer.accept(EVENT_BUS_MAP.get(modId));
        } else {
            Map<String, List<Consumer<IEventBus>>> map = ON_REGISTERED;
            synchronized (map) {
                ON_REGISTERED.computeIfAbsent(modId, s -> new ArrayList()).add(busConsumer);
            }
        }
    }

    public static Optional<IEventBus> getModEventBus(String modId) {
        return Optional.ofNullable(EVENT_BUS_MAP.get(modId));
    }
}

