/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.crafting;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;

public class CraftingJob {
    private final int id;
    private final int channel;
    private final IRecipeDefinition recipe;
    private final IntList dependencyCraftingJobs;
    private final IntList dependentCraftingJobs;
    private int amount;
    private IMixedIngredients ingredientsStorage;
    private Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> lastMissingIngredients;
    private long startTick;
    private boolean invalidInputs;
    @Nullable
    private String initiatorUuid;

    public CraftingJob(int id, int channel, IRecipeDefinition recipe, int amount, IMixedIngredients ingredientsStorage) {
        this.id = id;
        this.channel = channel;
        this.recipe = recipe;
        this.amount = amount;
        this.ingredientsStorage = ingredientsStorage;
        this.lastMissingIngredients = Maps.newIdentityHashMap();
        this.dependencyCraftingJobs = new IntArrayList();
        this.dependentCraftingJobs = new IntArrayList();
        this.invalidInputs = false;
    }

    public int getId() {
        return this.id;
    }

    public int getChannel() {
        return this.channel;
    }

    public IRecipeDefinition getRecipe() {
        return this.recipe;
    }

    public IntList getDependencyCraftingJobs() {
        return this.dependencyCraftingJobs;
    }

    public IntList getDependentCraftingJobs() {
        return this.dependentCraftingJobs;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void addDependency(CraftingJob dependency) {
        this.dependencyCraftingJobs.add(dependency.getId());
        dependency.dependentCraftingJobs.add(this.getId());
    }

    public void removeDependency(CraftingJob dependency) {
        this.dependencyCraftingJobs.rem(dependency.getId());
        dependency.dependentCraftingJobs.rem(this.getId());
    }

    public IMixedIngredients getIngredientsStorage() {
        return this.ingredientsStorage;
    }

    public void setIngredientsStorage(IMixedIngredients ingredientsStorage) {
        this.ingredientsStorage = ingredientsStorage;
    }

    public Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    public void setLastMissingIngredients(Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> lastMissingIngredients) {
        this.lastMissingIngredients = lastMissingIngredients;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public void setStartTick(long startTick) {
        this.startTick = startTick;
    }

    public boolean isInvalidInputs() {
        return this.invalidInputs;
    }

    public void setInvalidInputs(boolean invalidInputs) {
        this.invalidInputs = invalidInputs;
    }

    @Nullable
    public String getInitiatorUuid() {
        return this.initiatorUuid;
    }

    public void setInitiatorUuid(String initiatorUuid) {
        this.initiatorUuid = initiatorUuid;
    }

    public static CompoundTag serialize(CraftingJob craftingJob) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("id", craftingJob.id);
        tag.m_128405_("channel", craftingJob.channel);
        tag.m_128365_("recipe", (Tag)IRecipeDefinition.serialize((IRecipeDefinition)craftingJob.recipe));
        tag.m_128365_("dependencies", (Tag)new IntArrayTag((List)craftingJob.getDependencyCraftingJobs()));
        tag.m_128365_("dependents", (Tag)new IntArrayTag((List)craftingJob.getDependentCraftingJobs()));
        tag.m_128405_("amount", craftingJob.amount);
        tag.m_128365_("ingredientsStorage", (Tag)IMixedIngredients.serialize((IMixedIngredients)craftingJob.ingredientsStorage));
        tag.m_128365_("lastMissingIngredients", (Tag)MissingIngredients.serialize(craftingJob.lastMissingIngredients));
        tag.m_128356_("startTick", craftingJob.startTick);
        tag.m_128379_("invalidInputs", craftingJob.invalidInputs);
        if (craftingJob.initiatorUuid != null) {
            tag.m_128359_("initiatorUuid", craftingJob.initiatorUuid);
        }
        return tag;
    }

    public static CraftingJob deserialize(CompoundTag tag) {
        if (!tag.m_128425_("id", 3)) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.m_128425_("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        if (!tag.m_128425_("recipe", 10)) {
            throw new IllegalArgumentException("Could not find a recipe entry in the given tag");
        }
        if (!tag.m_128425_("dependencies", 11)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.m_128425_("dependents", 11)) {
            throw new IllegalArgumentException("Could not find a dependents entry in the given tag");
        }
        if (!tag.m_128425_("amount", 3)) {
            throw new IllegalArgumentException("Could not find a amount entry in the given tag");
        }
        if (!tag.m_128425_("ingredientsStorage", 10)) {
            throw new IllegalArgumentException("Could not find a ingredientsStorage entry in the given tag");
        }
        if (!tag.m_128425_("lastMissingIngredients", 10)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.m_128425_("startTick", 4)) {
            throw new IllegalArgumentException("Could not find a startTick entry in the given tag");
        }
        if (!tag.m_128425_("invalidInputs", 1)) {
            throw new IllegalArgumentException("Could not find an invalidInputs entry in the given tag");
        }
        int id = tag.m_128451_("id");
        int channel = tag.m_128451_("channel");
        RecipeDefinition recipe = IRecipeDefinition.deserialize((CompoundTag)tag.m_128469_("recipe"));
        int amount = tag.m_128451_("amount");
        MixedIngredients ingredientsStorage = IMixedIngredients.deserialize((CompoundTag)tag.m_128469_("ingredientsStorage"));
        CraftingJob craftingJob = new CraftingJob(id, channel, (IRecipeDefinition)recipe, amount, (IMixedIngredients)ingredientsStorage);
        for (int dependency : tag.m_128465_("dependencies")) {
            craftingJob.dependencyCraftingJobs.add(dependency);
        }
        for (int dependent : tag.m_128465_("dependents")) {
            craftingJob.dependentCraftingJobs.add(dependent);
        }
        Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> lastMissingIngredients = MissingIngredients.deserialize(tag.m_128469_("lastMissingIngredients"));
        craftingJob.setLastMissingIngredients(lastMissingIngredients);
        craftingJob.setStartTick(tag.m_128454_("startTick"));
        craftingJob.setInvalidInputs(tag.m_128471_("invalidInputs"));
        if (tag.m_128425_("initiatorUuid", 8)) {
            craftingJob.setInitiatorUuid(tag.m_128461_("initiatorUuid"));
        }
        return craftingJob;
    }

    public String toString() {
        return String.format("[Crafting Job id: %s, channel: %s, recipe: %s, dependencies: %s, dependents: %s, amount: %s, storage: %s]", this.getId(), this.getChannel(), this.getRecipe(), this.getDependencyCraftingJobs(), this.getDependentCraftingJobs(), this.getAmount(), this.getIngredientsStorage());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftingJob)) {
            return false;
        }
        CraftingJob that = (CraftingJob)obj;
        return this.getId() == that.getId() && this.getChannel() == that.getChannel() && Objects.equals(this.getRecipe(), that.getRecipe()) && this.getDependencyCraftingJobs().equals(that.getDependencyCraftingJobs()) && this.getDependentCraftingJobs().equals(that.getDependentCraftingJobs()) && this.getAmount() == that.getAmount() && this.getIngredientsStorage().equals(that.getIngredientsStorage());
    }

    public CraftingJob clone(CraftingHelpers.IIdentifierGenerator identifierGenerator) {
        return new CraftingJob(identifierGenerator.getNext(), this.getChannel(), this.getRecipe(), this.getAmount(), this.getIngredientsStorage());
    }
}

