/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.IntegratedCrafting;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobDependencyGraph;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingProcessOverride;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.MissingIngredients;
import org.cyclops.integratedcrafting.core.PendingCraftingJobResultIndexObserver;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class CraftingJobHandler {
    private final int maxProcessingJobs;
    private final ICraftingResultsSink resultsSink;
    private final Collection<ICraftingProcessOverride> craftingProcessOverrides;
    private final Int2ObjectMap<CraftingJob> allCraftingJobs;
    private final Int2ObjectMap<CraftingJob> processingCraftingJobs;
    private final Int2ObjectMap<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> processingCraftingJobsPendingIngredients;
    private final Int2ObjectMap<CraftingJob> pendingCraftingJobs;
    private final Object2IntMap<IngredientComponent<?, ?>> ingredientObserverCounters;
    private final Map<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> ingredientObservers;
    private final List<IngredientComponent<?, ?>> observersPendingCreation;
    private final List<IngredientComponent<?, ?>> observersPendingDeletion;
    private final Int2ObjectMap<CraftingJob> finishedCraftingJobs;
    private final Map<IngredientComponent<?, ?>, Direction> ingredientComponentTargetOverrides;

    public CraftingJobHandler(int maxProcessingJobs, Collection<ICraftingProcessOverride> craftingProcessOverrides, ICraftingResultsSink resultsSink) {
        this.maxProcessingJobs = maxProcessingJobs;
        this.resultsSink = resultsSink;
        this.craftingProcessOverrides = craftingProcessOverrides;
        this.allCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobs = new Int2ObjectOpenHashMap();
        this.pendingCraftingJobs = new Int2ObjectOpenHashMap();
        this.processingCraftingJobsPendingIngredients = new Int2ObjectOpenHashMap();
        this.ingredientObserverCounters = new Object2IntOpenHashMap();
        this.ingredientObservers = Maps.newIdentityHashMap();
        this.observersPendingCreation = Lists.newArrayList();
        this.observersPendingDeletion = Lists.newArrayList();
        this.finishedCraftingJobs = new Int2ObjectOpenHashMap();
        this.ingredientComponentTargetOverrides = Maps.newIdentityHashMap();
    }

    public void writeToNBT(CompoundTag tag) {
        ListTag processingCraftingJobs = new ListTag();
        for (CraftingJob processingCraftingJob : this.processingCraftingJobs.values()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_("craftingJob", (Tag)CraftingJob.serialize(processingCraftingJob));
            Map ingredients = (Map)this.processingCraftingJobsPendingIngredients.get(processingCraftingJob.getId());
            ListTag pendingIngredientInstances = new ListTag();
            for (Map.Entry ingredientComponentListEntry : ingredients.entrySet()) {
                CompoundTag ingredientInstance = new CompoundTag();
                IngredientComponent ingredientComponent = (IngredientComponent)ingredientComponentListEntry.getKey();
                ingredientInstance.m_128359_("ingredientComponent", ingredientComponent.getRegistryName().toString());
                ListTag instances = new ListTag();
                IIngredientSerializer serializer = ingredientComponent.getSerializer();
                for (IPrototypedIngredient prototypedIngredient : (List)ingredientComponentListEntry.getValue()) {
                    CompoundTag instance = new CompoundTag();
                    instance.m_128365_("prototype", serializer.serializeInstance(prototypedIngredient.getPrototype()));
                    instance.m_128365_("condition", serializer.serializeCondition(prototypedIngredient.getCondition()));
                    instances.add((Object)instance);
                }
                ingredientInstance.m_128365_("instances", (Tag)instances);
                pendingIngredientInstances.add((Object)ingredientInstance);
            }
            entryTag.m_128365_("pendingIngredientInstances", (Tag)pendingIngredientInstances);
            processingCraftingJobs.add((Object)entryTag);
        }
        tag.m_128365_("processingCraftingJobs", (Tag)processingCraftingJobs);
        ListTag pendingCraftingJobs = new ListTag();
        for (CraftingJob craftingJob : this.pendingCraftingJobs.values()) {
            pendingCraftingJobs.add((Object)CraftingJob.serialize(craftingJob));
        }
        tag.m_128365_("pendingCraftingJobs", (Tag)pendingCraftingJobs);
        CompoundTag targetOverrides = new CompoundTag();
        for (Map.Entry<IngredientComponent<?, ?>, Direction> entry : this.ingredientComponentTargetOverrides.entrySet()) {
            targetOverrides.m_128405_(entry.getKey().getName().toString(), entry.getValue().ordinal());
        }
        tag.m_128365_("targetOverrides", (Tag)targetOverrides);
    }

    public void readFromNBT(CompoundTag tag) {
        ListTag processingCraftingJobs = tag.m_128437_("processingCraftingJobs", 10);
        for (Object entry : processingCraftingJobs) {
            CompoundTag entryTag = (CompoundTag)entry;
            IdentityHashMap pendingIngredientInstances = Maps.newIdentityHashMap();
            ListTag pendingIngredientsList = entryTag.m_128437_("pendingIngredientInstances", 10);
            for (Tag pendingIngredient : pendingIngredientsList) {
                CompoundTag pendingIngredientTag = (CompoundTag)pendingIngredient;
                String componentName = pendingIngredientTag.m_128461_("ingredientComponent");
                IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                if (ingredientComponent == null) {
                    throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
                }
                IIngredientSerializer serializer = ingredientComponent.getSerializer();
                ArrayList pendingIngredients = Lists.newArrayList();
                for (Tag instanceTagUnsafe : pendingIngredientTag.m_128437_("instances", 10)) {
                    CompoundTag instanceTag = (CompoundTag)instanceTagUnsafe;
                    Object instance = serializer.deserializeInstance(instanceTag.m_128423_("prototype"));
                    Object condition = serializer.deserializeCondition(instanceTag.m_128423_("condition"));
                    pendingIngredients.add(new PrototypedIngredient(ingredientComponent, instance, condition));
                }
                pendingIngredientInstances.put(ingredientComponent, pendingIngredients);
            }
            CraftingJob craftingJob = CraftingJob.deserialize(entryTag.m_128469_("craftingJob"));
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), (Object)pendingIngredientInstances);
        }
        ListTag pendingCraftingJobs = tag.m_128437_("pendingCraftingJobs", 10);
        for (Tag craftingJob : pendingCraftingJobs) {
            CraftingJob craftingJobInstance = CraftingJob.deserialize((CompoundTag)craftingJob);
            this.pendingCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
            this.allCraftingJobs.put(craftingJobInstance.getId(), (Object)craftingJobInstance);
        }
        for (Map value : this.processingCraftingJobsPendingIngredients.values()) {
            this.observersPendingCreation.addAll(value.keySet());
        }
        this.ingredientComponentTargetOverrides.clear();
        CompoundTag targetOverrides = tag.m_128469_("targetOverrides");
        for (String componentName : targetOverrides.m_128431_()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            this.ingredientComponentTargetOverrides.put(component, Direction.values()[targetOverrides.m_128451_(componentName)]);
        }
    }

    public boolean canScheduleCraftingJobs() {
        return this.pendingCraftingJobs.size() < GeneralConfig.maxPendingCraftingJobs;
    }

    public void scheduleCraftingJob(CraftingJob craftingJob) {
        this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public Int2ObjectMap<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> getProcessingCraftingJobsPendingIngredients() {
        return this.processingCraftingJobsPendingIngredients;
    }

    public Int2ObjectMap<CraftingJob> getProcessingCraftingJobsRaw() {
        return this.processingCraftingJobs;
    }

    public Collection<CraftingJob> getProcessingCraftingJobs() {
        return this.getProcessingCraftingJobsRaw().values();
    }

    public Collection<CraftingJob> getPendingCraftingJobs() {
        return this.pendingCraftingJobs.values();
    }

    public void markCraftingJobProcessing(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (this.pendingCraftingJobs.remove(craftingJob.getId()) != null) {
            this.setCraftingJobProcessingPendingIngredients(craftingJob, pendingIngredients);
        }
    }

    public void unmarkCraftingJobProcessing(CraftingJob craftingJob) {
        if (this.processingCraftingJobs.remove(craftingJob.getId()) != null) {
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
            this.pendingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
    }

    public void setCraftingJobProcessingPendingIngredients(CraftingJob craftingJob, Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>> pendingIngredients) {
        if (pendingIngredients.isEmpty()) {
            this.processingCraftingJobs.remove(craftingJob.getId());
            this.processingCraftingJobsPendingIngredients.remove(craftingJob.getId());
            this.allCraftingJobs.remove(craftingJob.getId());
        } else {
            this.processingCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
            this.processingCraftingJobsPendingIngredients.put(craftingJob.getId(), pendingIngredients);
            this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        }
    }

    public List<IngredientComponent<?, ?>> getObserversPendingDeletion() {
        return this.observersPendingDeletion;
    }

    protected <T, M> void registerIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            PendingCraftingJobResultIndexObserver<T, M> observer = new PendingCraftingJobResultIndexObserver<T, M>(ingredientComponent, this);
            ingredientsNetwork.addObserver(observer);
            ingredientsNetwork.scheduleObservation();
            this.ingredientObservers.put(ingredientComponent, observer);
        }
        this.ingredientObserverCounters.put(ingredientComponent, count + 1);
    }

    protected <T, M> void unregisterIngredientObserver(IngredientComponent<T, M> ingredientComponent, INetwork network) {
        int count = this.ingredientObserverCounters.getInt(ingredientComponent);
        this.ingredientObserverCounters.put(ingredientComponent, --count);
        if (count == 0) {
            IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
            IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?> observer = this.ingredientObservers.remove(ingredientComponent);
            ingredientsNetwork.removeObserver(observer);
        }
    }

    public void onCraftingJobFinished(CraftingJob craftingJob) {
        this.processingCraftingJobs.remove(craftingJob.getId());
        this.pendingCraftingJobs.remove(craftingJob.getId());
        this.finishedCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        this.allCraftingJobs.put(craftingJob.getId(), (Object)craftingJob);
    }

    public void markCraftingJobFinished(int craftingJobId) {
        this.processingCraftingJobsPendingIngredients.remove(craftingJobId);
        this.processingCraftingJobs.remove(craftingJobId);
        this.pendingCraftingJobs.remove(craftingJobId);
        CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
        this.finishedCraftingJobs.put(craftingJobId, (Object)craftingJob);
        craftingJob.setAmount(1);
    }

    public void reRegisterObservers(INetwork network) {
        for (Map.Entry<IngredientComponent<?, ?>, IIngredientComponentStorageObservable.IIndexChangeObserver<?, ?>> entry : this.ingredientObservers.entrySet()) {
            IPositionedAddonsNetworkIngredients<?, ?> ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, entry.getKey());
            ingredientsNetwork.addObserver(entry.getValue());
        }
    }

    public void update(INetwork network, int channel, PartPos targetPos) {
        int processingJobs;
        if (this.observersPendingCreation.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingCreation) {
                this.registerIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingCreation.clear();
        }
        if (this.observersPendingDeletion.size() > 0) {
            for (IngredientComponent<?, ?> ingredientComponent : this.observersPendingDeletion) {
                this.unregisterIngredientObserver(ingredientComponent, network);
            }
            this.observersPendingDeletion.clear();
        }
        if (this.finishedCraftingJobs.size() > 0) {
            for (Object finishedCraftingJob : this.finishedCraftingJobs.values()) {
                if (((CraftingJob)finishedCraftingJob).getAmount() == 1) {
                    ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
                    iCraftingNetwork.onCraftingJobFinished((CraftingJob)finishedCraftingJob);
                    this.allCraftingJobs.remove(((CraftingJob)finishedCraftingJob).getId());
                    continue;
                }
                ((CraftingJob)finishedCraftingJob).setAmount(((CraftingJob)finishedCraftingJob).getAmount() - 1);
                this.pendingCraftingJobs.put(((CraftingJob)finishedCraftingJob).getId(), finishedCraftingJob);
            }
            this.finishedCraftingJobs.clear();
        }
        if ((processingJobs = this.getProcessingCraftingJobs().size()) > 0) {
            for (IngredientComponent ingredientComponent : this.ingredientObservers.keySet()) {
                IPositionedAddonsNetworkIngredients ingredientsNetwork = CraftingHelpers.getIngredientsNetworkChecked(network, ingredientComponent);
                ingredientsNetwork.scheduleObservation();
            }
        }
        if (processingJobs < this.maxProcessingJobs) {
            CraftingJob startingCraftingJob = null;
            ICraftingNetwork iCraftingNetwork = CraftingHelpers.getCraftingNetworkChecked(network);
            CraftingJobDependencyGraph dependencyGraph = iCraftingNetwork.getCraftingJobDependencyGraph();
            for (CraftingJob craftingJob : this.getPendingCraftingJobs()) {
                if (dependencyGraph.hasDependencies(craftingJob)) continue;
                Pair<Map<IngredientComponent<?, ?>, List<?>>, Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>>> inputs = CraftingHelpers.getRecipeInputs(CraftingHelpers.getNetworkStorageGetter(network, craftingJob.getChannel(), false), craftingJob.getRecipe(), true, Maps.newIdentityHashMap(), true, 1L);
                if (((Map)inputs.getRight()).isEmpty()) {
                    if (this.insertCrafting(targetPos, (IMixedIngredients)new MixedIngredients((Map)inputs.getLeft()), network, channel, true)) {
                        startingCraftingJob = craftingJob;
                        startingCraftingJob.setInvalidInputs(false);
                        break;
                    }
                    craftingJob.setInvalidInputs(true);
                    continue;
                }
                if (craftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent component : ((Map)inputs.getRight()).keySet()) {
                        this.registerIngredientObserver(component, network);
                    }
                }
                craftingJob.setLastMissingIngredients((Map)inputs.getRight());
            }
            if (startingCraftingJob != null) {
                IMixedIngredients ingredients;
                if (!startingCraftingJob.getLastMissingIngredients().isEmpty()) {
                    for (IngredientComponent ingredientComponent : startingCraftingJob.getLastMissingIngredients().keySet()) {
                        this.unregisterIngredientObserver(ingredientComponent, network);
                    }
                    startingCraftingJob.setLastMissingIngredients(Maps.newIdentityHashMap());
                }
                if ((ingredients = CraftingHelpers.getRecipeInputs(network, startingCraftingJob.getChannel(), startingCraftingJob.getRecipe(), false, 1L)) != null) {
                    this.markCraftingJobProcessing(startingCraftingJob, CraftingHelpers.getRecipeOutputs(startingCraftingJob.getRecipe()));
                    if (this.insertCrafting(targetPos, ingredients, network, channel, false)) {
                        for (IngredientComponent component : startingCraftingJob.getRecipe().getOutput().getComponents()) {
                            this.registerIngredientObserver(component, network);
                        }
                    } else {
                        startingCraftingJob.setInvalidInputs(true);
                        this.unmarkCraftingJobProcessing(startingCraftingJob);
                    }
                } else {
                    IntegratedCrafting.clog(Level.WARN, "Failed to extract ingredients for crafting job " + startingCraftingJob.getId());
                }
            }
        }
    }

    protected boolean insertCrafting(PartPos target, IMixedIngredients ingredients, INetwork network, int channel, boolean simulate) {
        Function<IngredientComponent<?, ?>, PartPos> targetGetter = this.getTargetGetter(target);
        for (ICraftingProcessOverride craftingProcessOverride : this.craftingProcessOverrides) {
            if (!craftingProcessOverride.isApplicable(target)) continue;
            return craftingProcessOverride.craft(targetGetter, ingredients, this.resultsSink, simulate);
        }
        return CraftingHelpers.insertCrafting(targetGetter, ingredients, network, channel, simulate);
    }

    public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
        if (this.pendingCraftingJobs.containsKey(craftingJobId)) {
            CraftingJob craftingJob = (CraftingJob)this.allCraftingJobs.get(craftingJobId);
            if (craftingJob != null && craftingJob.isInvalidInputs()) {
                return CraftingJobStatus.INVALID_INPUTS;
            }
            CraftingJobDependencyGraph dependencyGraph = network.getCraftingJobDependencyGraph();
            if (dependencyGraph.hasDependencies(craftingJobId)) {
                return CraftingJobStatus.PENDING_DEPENDENCIES;
            }
            if (!craftingJob.getLastMissingIngredients().isEmpty()) {
                return CraftingJobStatus.PENDING_INGREDIENTS;
            }
            return CraftingJobStatus.PENDING_INTERFACE;
        }
        if (this.processingCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.PROCESSING;
        }
        if (this.finishedCraftingJobs.containsKey(craftingJobId)) {
            return CraftingJobStatus.FINISHED;
        }
        return CraftingJobStatus.UNKNOWN;
    }

    public Int2ObjectMap<CraftingJob> getAllCraftingJobs() {
        return this.allCraftingJobs;
    }

    public void setIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent, @Nullable Direction side) {
        if (side == null) {
            this.ingredientComponentTargetOverrides.remove(ingredientComponent);
        } else {
            this.ingredientComponentTargetOverrides.put(ingredientComponent, side);
        }
    }

    @Nullable
    public Direction getIngredientComponentTarget(IngredientComponent<?, ?> ingredientComponent) {
        return this.ingredientComponentTargetOverrides.get(ingredientComponent);
    }

    public Function<IngredientComponent<?, ?>, PartPos> getTargetGetter(PartPos defaultPosition) {
        return ingredientComponent -> {
            Direction sideOverride = this.ingredientComponentTargetOverrides.get(ingredientComponent);
            if (sideOverride == null) {
                return defaultPosition;
            }
            return PartPos.of((DimPos)defaultPosition.getPos(), (Direction)sideOverride);
        };
    }
}

