/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client;

import fuzs.tradingpost.client.gui.screens.inventory.TradingPostScreen;
import fuzs.tradingpost.client.renderer.blockentity.TradingPostRenderer;
import fuzs.tradingpost.registry.ModRegistry;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.ReloadableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="tradingpost", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class TradingPostClient {
    public static final ResourceLocation MAGNIFYING_GLASS_LOCATION = new ResourceLocation("tradingpost", "item/magnifying_glass");
    public static final SearchRegistry.Key<MerchantOffer> OFFER_SEARCH_TREE = new SearchRegistry.Key();

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent evt) {
        MenuScreens.m_96206_((MenuType)((MenuType)ModRegistry.TRADING_POST_MENU_TYPE.get()), TradingPostScreen::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.get()), TradingPostRenderer::new);
        TradingPostClient.createSearchTree();
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            evt.addSprite(MAGNIFYING_GLASS_LOCATION);
        }
    }

    private static void createSearchTree() {
        ReloadableSearchTree offerSearchTree = new ReloadableSearchTree(offer -> Stream.of(offer.m_45352_(), offer.m_45364_(), offer.m_45368_()).filter(itemStack -> !itemStack.m_41619_()).flatMap(itemStack -> itemStack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.NORMAL).stream()).map(tooltipLine -> ChatFormatting.m_126649_((String)tooltipLine.getString()).trim()).filter(tooltipString -> !tooltipString.isEmpty()), offer -> Stream.of(offer.m_45352_(), offer.m_45364_(), offer.m_45368_()).filter(itemStack -> !itemStack.m_41619_()).map(ItemStack::m_41720_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)));
        Minecraft.m_91087_().getSearchTreeManager().m_119951_(OFFER_SEARCH_TREE, (MutableSearchTree)offerSearchTree);
    }
}

