/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import me.thonk.croptopia.BiomeLootCondition;
import me.thonk.croptopia.Composter;
import me.thonk.croptopia.blocks.CroptopiaCropBlock;
import me.thonk.croptopia.blocks.LeafCropBlock;
import me.thonk.croptopia.config.Config;
import me.thonk.croptopia.events.BiomeModification;
import me.thonk.croptopia.events.BlockBreakEvent;
import me.thonk.croptopia.events.CroptopiaVillagerTrades;
import me.thonk.croptopia.events.EntitySpawn;
import me.thonk.croptopia.events.Harvest;
import me.thonk.croptopia.events.LootTableModification;
import me.thonk.croptopia.items.CropItem;
import me.thonk.croptopia.items.SeedItem;
import me.thonk.croptopia.loot.SpawnChestModifier;
import me.thonk.croptopia.registry.BlockRegistry;
import me.thonk.croptopia.registry.GeneratorRegistry;
import me.thonk.croptopia.registry.ItemRegistry;
import me.thonk.croptopia.registry.LeavesRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croptopia")
public class CroptopiaForge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static ArrayList<Block> cropBlocks = new ArrayList();
    public static ArrayList<Block> leafBlocks = new ArrayList();
    public static ArrayList<SeedItem> seeds = new ArrayList();
    public static ArrayList<Item> cropItems = new ArrayList();
    public static LootItemConditionType BIOME_CHECK;
    private static final SpawnChestModifier.Serializer SPAWN_CHEST_MODIFIER;
    public static Config config;
    public static CreativeModeTab CROPTOPIA_ITEM_GROUP;
    private static boolean hasRun;

    public CroptopiaForge() {
        config = new Config();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(config::initConfig);
        MinecraftForge.EVENT_BUS.addListener(CroptopiaForge::onWorldLoad);
        MinecraftForge.EVENT_BUS.register((Object)new BiomeModification());
        MinecraftForge.EVENT_BUS.register((Object)new LootTableModification());
        MinecraftForge.EVENT_BUS.register((Object)new Harvest());
        MinecraftForge.EVENT_BUS.register((Object)new BlockBreakEvent());
        MinecraftForge.EVENT_BUS.register((Object)new CroptopiaVillagerTrades());
        MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CroptopiaForge.config.config);
        EventListenerHelper.getListenerList(PlayerInteractEvent.RightClickBlock.class);
        CROPTOPIA_ITEM_GROUP = new CreativeModeTab("croptopia"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ItemRegistry.coffee);
            }
        };
    }

    private void setup(FMLCommonSetupEvent event) {
        Composter.init();
        BIOME_CHECK = CroptopiaForge.registerLootCondition("biome_check", new BiomeLootCondition.Serializer());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        cropBlocks.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110457_()));
        BlockColors colors = Minecraft.m_91087_().m_91298_();
        colors.m_92589_((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), leafBlocks.toArray(new Block[0]));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)ItemRegistry.cookingPot));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)ItemRegistry.foodPress));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)ItemRegistry.fryingPan));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterTool", () -> new ItemStack((ItemLike)ItemRegistry.mortarAndPestle));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterWaterItem", () -> new ItemStack((ItemLike)ItemRegistry.waterBottle));
        InterModComms.sendTo((String)"cookingforblockheads", (String)"RegisterMilkItem", () -> new ItemStack((ItemLike)ItemRegistry.milkBottle));
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLDedicatedServerSetupEvent event) {
    }

    public static ResourceLocation createIdentifier(String name) {
        return new ResourceLocation("croptopia", name);
    }

    public static Item registerItem(RegistryEvent.Register<Item> itemRegister, String itemName, Item item) {
        item.setRegistryName(CroptopiaForge.createIdentifier(itemName));
        itemRegister.getRegistry().register((IForgeRegistryEntry)item);
        if (item instanceof ItemNameBlockItem) {
            ((ItemNameBlockItem)item).m_6192_(Item.f_41373_, item);
        }
        if (item instanceof CropItem) {
            cropItems.add(item);
        }
        if (item instanceof SeedItem) {
            SeedItem it = (SeedItem)item;
            CroptopiaCropBlock block = (CroptopiaCropBlock)it.m_40614_();
            block.setSeed(it);
        }
        if (item instanceof SeedItem) {
            seeds.add((SeedItem)item);
        }
        return item;
    }

    public static Block registerBlock(String blockName, Block block) {
        cropBlocks.add(block);
        if (block instanceof LeafCropBlock || block instanceof LeavesBlock) {
            leafBlocks.add(block);
        }
        block.setRegistryName(CroptopiaForge.createIdentifier(blockName));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        return block;
    }

    public static LootItemConditionType registerLootCondition(String id, Serializer<? extends LootItemCondition> serializer) {
        return (LootItemConditionType)Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("croptopia", id), (Object)new LootItemConditionType(serializer));
    }

    public static BlockBehaviour.Properties createCropSettings() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56758_);
    }

    public static BlockBehaviour.Properties createSaplingSettings() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_);
    }

    public static LeafCropBlock createLeavesBlock() {
        return new LeafCropBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56758_).m_60955_().m_60922_(CroptopiaForge::canSpawnOnLeaves).m_60960_(CroptopiaForge::never).m_60971_(CroptopiaForge::never));
    }

    public static LeavesBlock createRegularLeavesBlock() {
        return new LeavesBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76274_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56758_).m_60955_().m_60922_(CroptopiaForge::canSpawnOnLeaves).m_60960_(CroptopiaForge::never).m_60971_(CroptopiaForge::never));
    }

    private static Boolean canSpawnOnLeaves(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return type == EntityType.f_20505_ || type == EntityType.f_20508_;
    }

    private static boolean never(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    private static void modifyVillagerFoodItems() {
    }

    private static void modifyVillagerGatherables() {
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        if (!hasRun) {
            CroptopiaForge.modifyVillagerFoodItems();
            CroptopiaForge.modifyVillagerGatherables();
            hasRun = true;
        }
    }

    static {
        SPAWN_CHEST_MODIFIER = new SpawnChestModifier.Serializer();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LeavesRegistry.init();
            BlockRegistry.init();
            GeneratorRegistry.init();
        }

        @SubscribeEvent
        public static void onItemRegister(RegistryEvent.Register<Item> itemRegister) {
            ItemRegistry.init(itemRegister);
            ArrayList<SeedItem> chickenItems = new ArrayList<SeedItem>(seeds);
            chickenItems.addAll(Arrays.stream(Chicken.f_28233_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
            Chicken.f_28233_ = Ingredient.m_43929_((ItemLike[])chickenItems.toArray(new ItemLike[0]));
            ArrayList<SeedItem> parrotItems = new ArrayList<SeedItem>(Parrot.f_29357_);
            parrotItems.addAll(seeds);
            Parrot.f_29357_ = Sets.newHashSet(parrotItems);
            ArrayList<Item> pigItems = new ArrayList<Item>(Arrays.asList(ItemRegistry.yam, ItemRegistry.sweetPotato));
            pigItems.addAll(Arrays.stream(Pig.f_29458_.m_43908_()).map(ItemStack::m_41720_).collect(Collectors.toList()));
            Pig.f_29458_ = Ingredient.m_43929_((ItemLike[])pigItems.toArray(new ItemLike[0]));
        }

        @SubscribeEvent
        public static void onLootRegister(RegistryEvent.Register<GlobalLootModifierSerializer<?>> register) {
            SPAWN_CHEST_MODIFIER.setRegistryName(new ResourceLocation("croptopia", "spawn_loot"));
            register.getRegistry().register((IForgeRegistryEntry)SPAWN_CHEST_MODIFIER);
        }
    }
}

