/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="croptopia", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private final ForgeConfigSpec.Builder CONFIG_BUILDER = new ForgeConfigSpec.Builder();
    public ForgeConfigSpec config;
    public static ForgeConfigSpec.ConfigValue<Boolean> rightClickHarvest;
    public final Map<TreeConfiguration, TreeBuilder> builderMap = new HashMap<TreeConfiguration, TreeBuilder>();
    public static boolean canRightClickHarvest;

    public Config() {
        rightClickHarvest = this.CONFIG_BUILDER.comment("allows the user to right click harvest crops").translation("croptopia.config.rightclickharvest").define("rightClickHarvest", true);
        List<TreeConfiguration> trees = TreeConfiguration.init();
        this.CONFIG_BUILDER.comment("Croptopia tree generation").push("worldGeneration");
        for (TreeConfiguration tree : trees) {
            this.builderMap.put(tree, new TreeBuilder(this.CONFIG_BUILDER, tree));
        }
        this.CONFIG_BUILDER.pop();
        this.config = this.CONFIG_BUILDER.build();
    }

    @SubscribeEvent
    public void initConfig(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == this.config) {
            canRightClickHarvest = (Boolean)rightClickHarvest.get();
        }
    }

    public static class TreeConfiguration {
        String featureKey;
        List<ResourceKey<Biome>> treesInBiome;
        List<String> keys;

        public TreeConfiguration(String featureKey, List<ResourceKey<Biome>> treesInBiome) {
            this.featureKey = featureKey;
            this.treesInBiome = treesInBiome;
            this.keys = new ArrayList<String>();
            for (ResourceKey<Biome> biomeResourceKey : treesInBiome) {
                this.keys.add(biomeResourceKey.m_135782_().toString());
            }
        }

        public static void createSameTreeConfigs(SetMultimap<String, ResourceKey<Biome>> map, Collection<ResourceKey<Biome>> biomes, String ... keys) {
            for (String key : keys) {
                map.putAll((Object)key, biomes);
            }
        }

        public static List<TreeConfiguration> init() {
            List<ResourceKey<Biome>> forestBiomes = Arrays.asList(Biomes.f_48205_, Biomes.f_186767_, Biomes.f_48179_);
            List<ResourceKey<Biome>> jungleBiomes = Arrays.asList(Biomes.f_48222_, Biomes.f_186769_);
            List<ResourceKey<Biome>> plainsKeys = Arrays.asList(Biomes.f_48202_, Biomes.f_48176_);
            List<ResourceKey<Biome>> darkForestKeys = Arrays.asList(Biomes.f_48151_);
            HashMultimap biomes = HashMultimap.create();
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, forestBiomes, "lime_tree_configured", "pear_tree_configured", "apricot_tree_configured", "avocado_tree_configured", "star_fruit_tree_configured", "lemon_tree_configured", "cherry_tree_configured", "plum_tree_configured", "persimmon_tree_configured", "orange_tree_configured", "nectarine_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, jungleBiomes, "date_tree_configured", "dragon_fruit_tree_configured", "mango_tree_configured", "nutmeg_tree_configured", "coconut_tree_configured", "kumquat_tree_configured", "grapefruit_tree_configured", "banana_tree_configured", "fig_tree_configured", "cinnamon_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, plainsKeys, "apple_tree_configured", "orange_tree_configured", "peach_tree_configured");
            TreeConfiguration.createSameTreeConfigs((SetMultimap<String, ResourceKey<Biome>>)biomes, darkForestKeys, "almond_tree_configured", "cashew_tree_configured", "pecan_tree_configured", "walnut_tree_configured");
            ArrayList<TreeConfiguration> allTreeConfigs = new ArrayList<TreeConfiguration>();
            for (Map.Entry entry : biomes.asMap().entrySet()) {
                allTreeConfigs.add(new TreeConfiguration((String)entry.getKey(), new ArrayList<ResourceKey<Biome>>((Collection)entry.getValue())));
            }
            return allTreeConfigs;
        }
    }

    public static class TreeBuilder {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> acceptableBiomes;

        private TreeBuilder(ForgeConfigSpec.Builder builder, TreeConfiguration configuration) {
            this.acceptableBiomes = builder.comment("Settings for " + configuration.featureKey).push(configuration.featureKey).defineList("biomes", configuration.keys, o -> true);
            builder.pop();
        }
    }

    public static class CropConfiguration {
        String seed;
        List<String> biomes;

        public CropConfiguration(String seed, List<String> biomes) {
            this.seed = seed;
            this.biomes = biomes;
        }

        public static void init() {
        }
    }

    public static class CropBuilder {
    }
}

