/*
 * Decompiled with CFR 0.152.
 */
package me.thonk.croptopia.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import me.thonk.croptopia.registry.BlockRegistry;
import me.thonk.croptopia.registry.ItemRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import org.apache.commons.lang3.StringUtils;

public class CroptopiaDataGenerator {
    private static final List<Item> baseItems = ImmutableList.of((Object)ItemRegistry.shepherdsPie, (Object)ItemRegistry.beefWellington, (Object)ItemRegistry.fishAndChips, (Object)ItemRegistry.etonMess, (Object)ItemRegistry.tea, (Object)ItemRegistry.cornishPasty, (Object)ItemRegistry.scones, (Object)ItemRegistry.figgyPudding, (Object)ItemRegistry.treacleTart, (Object)ItemRegistry.stickyToffeePudding, (Object)ItemRegistry.trifle, (Object)ItemRegistry.pepperSeed, (Object[])new Item[]{ItemRegistry.waterBottle, ItemRegistry.milkBottle, ItemRegistry.teaLeaves, ItemRegistry.teaSeed});
    private static final List<Item> blockItemGeneratedModels = ImmutableList.of((Object)ItemRegistry.appleSapling);
    private static final List<Block> cropBlocks = ImmutableList.of((Object)BlockRegistry.teaCropBlock);
    private static final List<Item> carbFoodsTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);
    private static final List<Item> fatsFoodTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);
    private static final List<Item> fruitFoodTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);
    private static final List<Item> proteinFoodTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);
    private static final List<Item> sweetsFoodTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);
    private static final List<Item> veggieFoodTag = ImmutableList.of((Object)ItemRegistry.shepherdsPie);

    public static class ItemGenerator
    extends ItemModelProvider {
        public ItemGenerator(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
            super(generator, modid, existingFileHelper);
        }

        protected void registerModels() {
            ResourceLocation resourceLocation;
            for (Item cropItem : baseItems) {
                resourceLocation = cropItem.getRegistryName();
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(resourceLocation.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + resourceLocation.m_135815_()));
            }
            for (Item blockItemGeneratedModel : blockItemGeneratedModels) {
                resourceLocation = blockItemGeneratedModel.getRegistryName();
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(resourceLocation.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("block/" + resourceLocation.m_135815_()));
            }
        }
    }

    public static class LanguageGenerator
    extends LanguageProvider {
        public LanguageGenerator(DataGenerator gen, String modid, String locale) {
            super(gen, modid, locale);
        }

        protected void addTranslations() {
            String path;
            ResourceLocation location;
            for (Item item : baseItems) {
                location = item.getRegistryName();
                path = location.m_135815_();
                this.add(item, StringUtils.capitalize((String)path.replaceAll("_", " ")));
            }
            for (Item item : blockItemGeneratedModels) {
                location = item.getRegistryName();
                path = location.m_135815_();
                this.add(item, StringUtils.capitalize((String)path.replaceAll("_", " ")));
            }
            for (Block block : cropBlocks) {
                location = block.getRegistryName();
                path = location.m_135815_();
                this.add(block, StringUtils.capitalize((String)path.replaceAll("_", " ")));
            }
        }
    }

    public static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(DataGenerator dataGenerator, BlockTagsProvider blockTagProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagProvider, modId, existingFileHelper);
        }

        protected void m_6577_() {
        }

        public String m_6055_() {
            return "Croptopia Item Tags";
        }
    }

    public static class BlockTagGenerator
    extends BlockTagsProvider {
        public BlockTagGenerator(DataGenerator generatorIn, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(generatorIn, modId, existingFileHelper);
        }

        protected void m_6577_() {
        }

        public String m_6055_() {
            return "Croptopia Block Tags";
        }
    }
}

