/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.core;

import com.github.almostreliable.energymeter.meter.MeterBlock;
import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public final class Setup {
    private static final Tab TAB = new Tab("energymeter");

    private Setup() {
    }

    public static void init(IEventBus modEventBus) {
        Blocks.REGISTRY.register(modEventBus);
        Blocks.ITEMS.register(modEventBus);
        Entities.REGISTRY.register(modEventBus);
        Containers.REGISTRY.register(modEventBus);
    }

    private static <E extends IForgeRegistryEntry<E>> DeferredRegister<E> createRegistry(IForgeRegistry<E> registry) {
        return DeferredRegister.create(registry, (String)"energymeter");
    }

    private static final class Blocks {
        private static final DeferredRegister<Block> REGISTRY = Setup.createRegistry(ForgeRegistries.BLOCKS);
        private static final DeferredRegister<Item> ITEMS = Setup.createRegistry(ForgeRegistries.ITEMS);
        private static final RegistryObject<MeterBlock> METER = Blocks.register("meter", MeterBlock::new);

        private Blocks() {
        }

        private static <B extends MeterBlock> RegistryObject<B> register(String id, Supplier<B> supplier) {
            RegistryObject result = REGISTRY.register(id, supplier);
            ITEMS.register(id, () -> new BlockItem((Block)result.get(), new Item.Properties().m_41491_((CreativeModeTab)TAB)));
            return result;
        }
    }

    public static final class Entities {
        private static final DeferredRegister<BlockEntityType<?>> REGISTRY = Setup.createRegistry(ForgeRegistries.BLOCK_ENTITIES);
        public static final RegistryObject<BlockEntityType<MeterEntity>> METER = Entities.register("meter", Blocks.METER, MeterEntity::new);

        private Entities() {
        }

        private static <E extends MeterEntity, B extends MeterBlock> RegistryObject<BlockEntityType<E>> register(String id, RegistryObject<B> block, BlockEntityType.BlockEntitySupplier<E> entity) {
            return REGISTRY.register(id, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)entity, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
        }
    }

    public static final class Containers {
        private static final DeferredRegister<MenuType<?>> REGISTRY = Setup.createRegistry(ForgeRegistries.CONTAINERS);
        public static final RegistryObject<MenuType<MeterContainer>> METER = Containers.register("meter", MeterContainer::new);

        private Containers() {
        }

        private static <C extends MeterContainer> RegistryObject<MenuType<C>> register(String id, BiFunction<? super MeterEntity, ? super Integer, ? extends C> constructor) {
            return REGISTRY.register(id, () -> IForgeMenuType.create((containerID, inventory, data) -> {
                MeterEntity entity = (MeterEntity)inventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
                return (MeterContainer)((Object)((Object)((Object)constructor.apply(entity, containerID))));
            }));
        }
    }

    private static final class Tab
    extends CreativeModeTab {
        private Tab(String label) {
            super(label);
        }

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Blocks.METER.get());
        }
    }
}

