/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class AccuracyUpdatePacket {
    private TypeEnums.TEXT_BOX identifier;
    private int value;

    public AccuracyUpdatePacket(TypeEnums.TEXT_BOX identifier, int value) {
        this.identifier = identifier;
        this.value = value;
    }

    private AccuracyUpdatePacket() {
    }

    static AccuracyUpdatePacket decode(FriendlyByteBuf buffer) {
        AccuracyUpdatePacket packet = new AccuracyUpdatePacket();
        packet.identifier = TypeEnums.TEXT_BOX.values()[buffer.readInt()];
        packet.value = buffer.readInt();
        return packet;
    }

    static void handle(AccuracyUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        context.get().enqueueWork(() -> AccuracyUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(AccuracyUpdatePacket packet, @Nullable ServerPlayer player) {
        if (player != null && player.f_36096_ instanceof MeterContainer) {
            MeterEntity entity = ((MeterContainer)player.f_36096_).getEntity();
            Level level = entity.m_58904_();
            if (level == null || !level.m_46749_(entity.m_58899_())) {
                return;
            }
            if (packet.identifier == TypeEnums.TEXT_BOX.INTERVAL) {
                entity.setInterval(packet.value);
                entity.syncData(64);
            } else if (packet.identifier == TypeEnums.TEXT_BOX.THRESHOLD) {
                entity.setThreshold(packet.value);
                entity.syncData(128);
            }
            entity.m_6596_();
        }
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.identifier.ordinal());
        buffer.writeInt(this.value);
    }
}

