/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.component.SideConfiguration;
import com.github.almostreliable.energymeter.network.ClientHandler;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientSyncPacket {
    private BlockPos pos;
    private int flags;
    private CompoundTag sideConfig;
    private double transferRate;
    private TypeEnums.NUMBER_MODE numberMode;
    private TypeEnums.STATUS status;
    private TypeEnums.MODE mode;
    private TypeEnums.ACCURACY accuracy;
    private int interval;
    private int threshold;

    public ClientSyncPacket(BlockPos pos, int flags, SideConfiguration sideConfig, double transferRate, TypeEnums.NUMBER_MODE numberMode, TypeEnums.STATUS status, TypeEnums.MODE mode, TypeEnums.ACCURACY accuracy, int interval, int threshold) {
        this.pos = pos;
        this.flags = flags;
        this.sideConfig = sideConfig.serializeNBT();
        this.transferRate = transferRate;
        this.numberMode = numberMode;
        this.status = status;
        this.mode = mode;
        this.accuracy = accuracy;
        this.interval = interval;
        this.threshold = threshold;
    }

    private ClientSyncPacket() {
    }

    static ClientSyncPacket decode(FriendlyByteBuf buffer) {
        ClientSyncPacket packet = new ClientSyncPacket();
        packet.pos = buffer.m_130135_();
        packet.flags = buffer.readInt();
        if ((packet.flags & 1) != 0) {
            packet.sideConfig = Objects.requireNonNull(buffer.m_130260_());
        }
        if ((packet.flags & 2) != 0) {
            packet.transferRate = buffer.readDouble();
        }
        if ((packet.flags & 4) != 0) {
            packet.numberMode = TypeEnums.NUMBER_MODE.values()[buffer.readInt()];
        }
        if ((packet.flags & 8) != 0) {
            packet.status = TypeEnums.STATUS.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x10) != 0) {
            packet.mode = TypeEnums.MODE.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x20) != 0) {
            packet.accuracy = TypeEnums.ACCURACY.values()[buffer.readInt()];
        }
        if ((packet.flags & 0x40) != 0) {
            packet.interval = buffer.readInt();
        }
        return packet;
    }

    static void handle(ClientSyncPacket packet, Supplier<? extends NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientSyncPacket.handlePacket(packet));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(ClientSyncPacket packet) {
        ClientHandler.handleClientSyncPacket(packet);
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.flags);
        if ((this.flags & 1) != 0) {
            buffer.m_130079_(this.sideConfig);
        }
        if ((this.flags & 2) != 0) {
            buffer.writeDouble(this.transferRate);
        }
        if ((this.flags & 4) != 0) {
            buffer.writeInt(this.numberMode.ordinal());
        }
        if ((this.flags & 8) != 0) {
            buffer.writeInt(this.status.ordinal());
        }
        if ((this.flags & 0x10) != 0) {
            buffer.writeInt(this.mode.ordinal());
        }
        if ((this.flags & 0x20) != 0) {
            buffer.writeInt(this.accuracy.ordinal());
        }
        if ((this.flags & 0x40) != 0) {
            buffer.writeInt(this.interval);
        }
        if ((this.flags & 0x80) != 0) {
            buffer.writeInt(this.threshold);
        }
    }

    BlockPos getPos() {
        return this.pos;
    }

    int getFlags() {
        return this.flags;
    }

    CompoundTag getSideConfig() {
        return this.sideConfig;
    }

    double getTransferRate() {
        return this.transferRate;
    }

    TypeEnums.NUMBER_MODE getNumberMode() {
        return this.numberMode;
    }

    TypeEnums.STATUS getStatus() {
        return this.status;
    }

    public TypeEnums.MODE getMode() {
        return this.mode;
    }

    TypeEnums.ACCURACY getAccuracy() {
        return this.accuracy;
    }

    int getInterval() {
        return this.interval;
    }

    int getThreshold() {
        return this.threshold;
    }
}

