/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class IOUpdatePacket {
    private TypeEnums.BLOCK_SIDE side;
    private TypeEnums.IO_SETTING setting;

    public IOUpdatePacket(TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.side = side;
        this.setting = setting;
    }

    private IOUpdatePacket() {
    }

    static IOUpdatePacket decode(FriendlyByteBuf buffer) {
        IOUpdatePacket packet = new IOUpdatePacket();
        packet.side = TypeEnums.BLOCK_SIDE.values()[buffer.readInt()];
        packet.setting = TypeEnums.IO_SETTING.values()[buffer.readInt()];
        return packet;
    }

    static void handle(IOUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        context.get().enqueueWork(() -> IOUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(IOUpdatePacket packet, @Nullable ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof MeterContainer) {
            MeterContainer menu = (MeterContainer)abstractContainerMenu;
            MeterEntity entity = menu.getEntity();
            Level level = entity.m_58904_();
            if (level == null || !level.m_46749_(entity.m_58899_())) {
                return;
            }
            entity.getSideConfig().set(packet.side, packet.setting);
            entity.updateNeighbors();
            entity.updateCache(entity.getSideConfig().getDirectionFromSide(packet.side));
            entity.syncData(1);
            entity.m_6596_();
        }
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.side.ordinal());
        buffer.writeInt(this.setting.ordinal());
    }
}

