/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.meter.MeterContainer;
import com.github.almostreliable.energymeter.meter.MeterEntity;
import com.github.almostreliable.energymeter.util.TypeEnums;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class SettingUpdatePacket {
    private TypeEnums.SETTING setting;

    public SettingUpdatePacket(TypeEnums.SETTING setting) {
        this.setting = setting;
    }

    private SettingUpdatePacket() {
    }

    static SettingUpdatePacket decode(FriendlyByteBuf buffer) {
        SettingUpdatePacket packet = new SettingUpdatePacket();
        packet.setting = TypeEnums.SETTING.values()[buffer.readInt()];
        return packet;
    }

    static void handle(SettingUpdatePacket packet, Supplier<? extends NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        context.get().enqueueWork(() -> SettingUpdatePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(SettingUpdatePacket packet, @Nullable ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu;
        if (player != null && (abstractContainerMenu = player.f_36096_) instanceof MeterContainer) {
            MeterContainer menu = (MeterContainer)abstractContainerMenu;
            MeterEntity entity = menu.getEntity();
            Level level = entity.m_58904_();
            if (level == null || !level.m_46749_(entity.m_58899_())) {
                return;
            }
            entity.updateSetting(packet.setting);
            entity.m_6596_();
        }
    }

    void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.setting.ordinal());
    }
}

