/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.util;

import com.github.almostreliable.energymeter.util.TextUtils;
import com.github.almostreliable.energymeter.util.TypeEnums;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public final class GuiUtils {
    private GuiUtils() {
    }

    public static void renderText(PoseStack stack, int x, int y, float scale, String text, int color) {
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 0.0);
        stack.m_85841_(scale, scale, 1.0f);
        Minecraft.m_91087_().f_91062_.m_92883_(stack, text, 0.0f, 0.0f, color);
        stack.m_85849_();
    }

    public static final class Tooltip {
        private final List<Component> value = new ArrayList<Component>();

        private Tooltip() {
        }

        public static Tooltip builder() {
            return new Tooltip();
        }

        public List<Component> resolve() {
            return this.value;
        }

        public Tooltip addBlankLine() {
            return this.addComponent((Component)new TextComponent(" "));
        }

        public Tooltip addComponent(Component component) {
            this.value.add(component);
            return this;
        }

        public Tooltip addHeader(String key) {
            return this.addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GOLD));
        }

        public Tooltip addDescription(String key) {
            return this.addComponent((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.WHITE));
        }

        public Tooltip addCustomAction(String input, String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(InputConstants.m_84851_((String)input).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public Tooltip addClickAction(String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click", ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public Tooltip addHoldAction(String input, String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_hold", ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)TextUtils.colorize(InputConstants.m_84851_((String)input).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }

        public Tooltip addShiftClickAction(String key) {
            return this.addComponent((Component)TextUtils.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(String.format("%s + %s", InputConstants.m_84851_((String)"key.keyboard.left.shift").m_84875_().getString(), TextUtils.translateAsString(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click")), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtils.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)));
        }
    }
}

