/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.client;

import elucent.rootsclassic.client.model.SylvanArmorModel;
import elucent.rootsclassic.client.model.WildwoodArmorModel;
import elucent.rootsclassic.client.renderer.block.AltarBER;
import elucent.rootsclassic.client.renderer.block.BrazierBER;
import elucent.rootsclassic.client.renderer.block.ImbuerBER;
import elucent.rootsclassic.client.renderer.block.MortarBER;
import elucent.rootsclassic.client.renderer.entity.AcceleratorRenderer;
import elucent.rootsclassic.client.renderer.entity.PhantomSkeletonRenderer;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.item.CrystalStaffItem;
import elucent.rootsclassic.item.StaffItem;
import elucent.rootsclassic.registry.RootsEntities;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.RootsUtil;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientHandler {
    public static final ModelLayerLocation SYLVAN_ARMOR = new ModelLayerLocation(new ResourceLocation("rootsclassic", "main"), "sylvan_armor");
    public static final ModelLayerLocation WILDWOOD_ARMOR = new ModelLayerLocation(new ResourceLocation("rootsclassic", "main"), "wildwood_armor");

    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RootsRegistry.MIDNIGHT_BLOOM.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RootsRegistry.FLARE_ORCHID.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RootsRegistry.RADIANT_DAISY.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RootsRegistry.ALTAR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)RootsRegistry.BRAZIER.get()), (RenderType)RenderType.m_110463_());
        ItemProperties.register((Item)((Item)RootsRegistry.STAFF.get()), (ResourceLocation)new ResourceLocation("imbued"), (stack, world, livingEntity, unused) -> stack.m_41783_() != null && stack.m_41783_().m_128441_("rootsclassic:effect") ? 1.0f : 0.0f);
    }

    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.MORTAR_TILE.get(), MortarBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.IMBUER_TILE.get(), ImbuerBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.ALTAR_TILE.get(), AltarBER::new);
        event.registerBlockEntityRenderer((BlockEntityType)RootsRegistry.BRAZIER_TILE.get(), BrazierBER::new);
        event.registerEntityRenderer((EntityType)RootsEntities.PHANTOM_SKELETON.get(), PhantomSkeletonRenderer::new);
        event.registerEntityRenderer((EntityType)RootsEntities.ENTITY_ACCELERATOR.get(), AcceleratorRenderer::new);
        event.registerEntityRenderer((EntityType)RootsEntities.TILE_ACCELERATOR.get(), AcceleratorRenderer::new);
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(SYLVAN_ARMOR, () -> SylvanArmorModel.createArmorDefinition());
        event.registerLayerDefinition(WILDWOOD_ARMOR, () -> WildwoodArmorModel.createArmorDefinition());
    }

    public static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.m_92689_((stack, tintIndex) -> {
            ComponentBase comp;
            CompoundTag tag;
            ResourceLocation compName;
            if (stack.m_41782_() && stack.m_41720_() instanceof StaffItem && (compName = ResourceLocation.m_135820_((String)(tag = stack.m_41783_()).m_128461_("rootsclassic:effect"))) != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                if (tintIndex == 2) {
                    return RootsUtil.intColor((int)comp.primaryColor.f_82479_, (int)comp.primaryColor.f_82480_, (int)comp.primaryColor.f_82481_);
                }
                if (tintIndex == 1) {
                    return RootsUtil.intColor((int)comp.secondaryColor.f_82479_, (int)comp.secondaryColor.f_82480_, (int)comp.secondaryColor.f_82481_);
                }
            }
            return RootsUtil.intColor(255, 255, 255);
        }, new ItemLike[]{(ItemLike)RootsRegistry.STAFF.get()});
        colors.m_92689_((stack, tintIndex) -> {
            ComponentBase comp;
            ResourceLocation compName;
            String effect;
            if (stack.m_41720_() instanceof CrystalStaffItem && stack.m_41782_() && (effect = CrystalStaffItem.getEffect(stack)) != null && (compName = ResourceLocation.m_135820_((String)effect)) != null && (comp = ComponentManager.getComponentFromName(compName)) != null) {
                if (tintIndex == 2) {
                    return RootsUtil.intColor((int)comp.primaryColor.f_82479_, (int)comp.primaryColor.f_82480_, (int)comp.primaryColor.f_82481_);
                }
                if (tintIndex == 1) {
                    return RootsUtil.intColor((int)comp.secondaryColor.f_82479_, (int)comp.secondaryColor.f_82480_, (int)comp.secondaryColor.f_82481_);
                }
            }
            return RootsUtil.intColor(255, 255, 255);
        }, new ItemLike[]{(ItemLike)RootsRegistry.CRYSTAL_STAFF.get()});
    }
}

