/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.rootsclassic.Spell")
public class SpellZen
implements IRecipeManager {
    @ZenCodeGlobals.Global(value="spell")
    public static final SpellZen INSTANCE = new SpellZen();

    private SpellZen() {
    }

    @ZenCodeType.Method
    public void setSpellIngredients(ResourceLocation name, IItemStack[] ingredients) {
        if (ingredients.length == 0 || ingredients.length > 4) {
            throw new IllegalArgumentException("Invalid spell ingredients, must be in range [1,4]");
        }
        ComponentRecipe found = this.findSpellByName(name);
        CraftTweakerAPI.LOGGER.info("Changing spell ingredients of " + found.getEffectResult());
        NonNullList ingredientList = NonNullList.m_122779_();
        for (IItemStack ingredient : ingredients) {
            ingredientList.add((Object)ingredient.asVanillaIngredient());
        }
        ComponentRecipe newRecipe = new ComponentRecipe(found.m_6423_(), found.getEffectResult(), found.m_6076_(), found.m_8043_(), (NonNullList<Ingredient>)ingredientList, found.needsMixin());
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipeByName((IRecipeManager)INSTANCE, found.m_6423_()));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)newRecipe));
    }

    @ZenCodeType.Method
    public void addMortarCrafting(String uniqueName, IItemStack[] items, IItemStack output) {
        if (items.length == 0 || items.length > 4) {
            throw new IllegalArgumentException("Invalid ingredient size, must be in range [1,4]");
        }
        NonNullList ingredients = NonNullList.m_122779_();
        for (IItemStack stack : items) {
            ingredients.add((Object)stack.asVanillaIngredient());
        }
        ComponentRecipe craftingRecipe = new ComponentRecipe(new ResourceLocation("crafttweaker", uniqueName), new ResourceLocation("rootsclassic", "none"), "crafttweaker", output.getInternal(), (NonNullList<Ingredient>)ingredients, true);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (Recipe)craftingRecipe));
    }

    private ComponentRecipe findSpellByName(ResourceLocation name) {
        ComponentRecipe found = ComponentManager.getSpellFromName(CraftTweakerAPI.getRecipeManager(), name);
        if (found == null) {
            StringBuilder names = new StringBuilder();
            for (ComponentRecipe recipe : CraftTweakerAPI.getRecipeManager().m_44013_(RootsRecipes.COMPONENT_RECIPE_TYPE)) {
                if (!name.m_135827_().equals("rootsclassic") || name.m_135815_().equals("none")) continue;
                names.append(recipe.getEffectResult()).append(", ");
            }
            throw new IllegalArgumentException("Invalid spell [" + name + "], names must be one of: " + names);
        }
        return found;
    }

    public RecipeType<?> getRecipeType() {
        return RootsRecipes.COMPONENT_RECIPE_TYPE;
    }
}

