/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lkotlinx/serialization/internal/InternalHexConverter;", "", "()V", "hexCode", "", "hexToInt", "", "ch", "", "parseHexBinary", "", "s", "printHexBinary", "data", "lowerCase", "", "toHexString", "n", "kotlinx-serialization-core"})
public final class InternalHexConverter {
    @NotNull
    public static final InternalHexConverter INSTANCE = new InternalHexConverter();
    @NotNull
    private static final String hexCode = "0123456789ABCDEF";

    private InternalHexConverter() {
    }

    @NotNull
    public final byte[] parseHexBinary(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        int len = s.length();
        if (!(len % 2 == 0)) {
            boolean $i$a$-require-InternalHexConverter$parseHexBinary$32 = false;
            String $i$a$-require-InternalHexConverter$parseHexBinary$32 = "HexBinary string must be even length";
            throw new IllegalArgumentException($i$a$-require-InternalHexConverter$parseHexBinary$32.toString());
        }
        byte[] bytes = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            int h = this.hexToInt(s.charAt(i2));
            int l = this.hexToInt(s.charAt(i2 + 1));
            if (!(h != -1 && l != -1)) {
                boolean bl = false;
                String string = "Invalid hex chars: " + s.charAt(i2) + s.charAt(i2 + 1);
                throw new IllegalArgumentException(string.toString());
            }
            bytes[i2 / 2] = (byte)((h << 4) + l);
        }
        return bytes;
    }

    private final int hexToInt(char ch) {
        int n;
        block1: {
            char c;
            block0: {
                c = ch;
                boolean bl = '0' <= c ? c < ':' : false;
                if (!bl) break block0;
                n = ch - 48;
                break block1;
            }
            n = ('A' <= c ? c < 'G' : false) ? ch - 65 + 10 : (('a' <= c ? c < 'g' : false) ? ch - 97 + 10 : -1);
        }
        return n;
    }

    @NotNull
    public final String printHexBinary(@NotNull byte[] data2, boolean lowerCase) {
        String string;
        Intrinsics.checkNotNullParameter(data2, "data");
        StringBuilder r = new StringBuilder(data2.length * 2);
        for (byte b : data2) {
            r.append(hexCode.charAt(b >> 4 & 0xF));
            r.append(hexCode.charAt(b & 0xF));
        }
        if (lowerCase) {
            String string2 = r.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "r.toString()");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            string = string3;
        } else {
            String string4 = r.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "r.toString()");
            string = string4;
        }
        return string;
    }

    public static /* synthetic */ String printHexBinary$default(InternalHexConverter internalHexConverter, byte[] byArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return internalHexConverter.printHexBinary(byArray, bl);
    }

    @NotNull
    public final String toHexString(int n) {
        byte[] arr = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            int i2 = n2++;
            arr[i2] = (byte)(n >> 24 - i2 * 8);
        }
        Object object = new char[]{'0'};
        Object it = object = (Object)StringsKt.trimStart(this.printHexBinary(arr, true), object);
        boolean bl = false;
        Object object2 = (char[])(((CharSequence)it).length() > 0 ? object : null);
        if (object2 == null) {
            object2 = "0";
        }
        return object2;
    }
}

