/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.kotlinforforge;

import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.kotlinforforge.AutoKotlinEventBusSubscriber;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;
import thedarkcolour.kotlinforforge.LoggerKt;
import thedarkcolour.kotlinforforge.kotlin.KotlinKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ#\u0010\u0013\u001a\u00020\u0014\"\f\b\u0000\u0010\u0015*\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u0002H\u0015H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0016J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0016J;\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010)R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lthedarkcolour/kotlinforforge/KotlinModContainer;", "Lnet/minecraftforge/fml/ModContainer;", "info", "Lnet/minecraftforge/forgespi/language/IModInfo;", "className", "", "scanResults", "Lnet/minecraftforge/forgespi/language/ModFileScanData;", "gameLayer", "Ljava/lang/ModuleLayer;", "(Lnet/minecraftforge/forgespi/language/IModInfo;Ljava/lang/String;Lnet/minecraftforge/forgespi/language/ModFileScanData;Ljava/lang/ModuleLayer;)V", "eventBus", "Lnet/minecraftforge/eventbus/api/IEventBus;", "getEventBus", "()Lnet/minecraftforge/eventbus/api/IEventBus;", "modClass", "Ljava/lang/Class;", "modInstance", "", "acceptEvent", "", "T", "Lnet/minecraftforge/eventbus/api/Event;", "Lnet/minecraftforge/fml/event/IModBusEvent;", "e", "(Lnet/minecraftforge/eventbus/api/Event;)V", "constructMod", "getMod", "matches", "", "mod", "onEventFailed", "iEventBus", "event", "listeners", "", "Lnet/minecraftforge/eventbus/api/IEventListener;", "busId", "", "throwable", "", "(Lnet/minecraftforge/eventbus/api/IEventBus;Lnet/minecraftforge/eventbus/api/Event;[Lnet/minecraftforge/eventbus/api/IEventListener;ILjava/lang/Throwable;)V", "KotlinForForge"})
public final class KotlinModContainer
extends ModContainer {
    @NotNull
    private final ModFileScanData scanResults;
    private Object modInstance;
    @NotNull
    private final IEventBus eventBus;
    @NotNull
    private final Class<?> modClass;

    public KotlinModContainer(@NotNull IModInfo info, @NotNull String className, @NotNull ModFileScanData scanResults, @NotNull ModuleLayer gameLayer) {
        Intrinsics.checkNotNullParameter(info, "info");
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(scanResults, "scanResults");
        Intrinsics.checkNotNullParameter(gameLayer, "gameLayer");
        super(info);
        this.scanResults = scanResults;
        LoggerKt.getLOGGER().debug(LogMarkers.LOADING, "Creating KotlinModContainer instance for " + className);
        Map map2 = this.activityMap;
        Intrinsics.checkNotNullExpressionValue(map2, "activityMap");
        map2.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBus = (IEventBus)new EventBus(BusBuilder.builder().setExceptionHandler(this::onEventFailed).setTrackPhases(false).markerType(IModBusEvent.class));
        this.configHandler = Optional.of(arg_0 -> KotlinModContainer._init_$lambda-0(this, arg_0));
        this.contextExtension = KotlinKt.supply(new KotlinModLoadingContext(this));
        try {
            Module layer = gameLayer.findModule(info.getOwningFile().moduleName()).orElseThrow();
            Class<?> clazz = Class.forName(layer, className);
            Intrinsics.checkNotNullExpressionValue(clazz, "forName(layer, className)");
            this.modClass = clazz;
            LoggerKt.getLOGGER().trace(LogMarkers.LOADING, "Loaded modclass " + this.modClass.getName() + " with " + this.modClass.getClassLoader());
        }
        catch (Throwable t) {
            LoggerKt.getLOGGER().error(LogMarkers.LOADING, "Failed to load class " + className, t);
            throw new ModLoadingException(info, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", t, new Object[0]);
        }
    }

    @NotNull
    public final IEventBus getEventBus() {
        return this.eventBus;
    }

    private final void onEventFailed(IEventBus iEventBus, Event event, IEventListener[] listeners, int busId, Throwable throwable) {
        LoggerKt.getLOGGER().error((Message)new EventBusErrorMessage(event, busId, listeners, throwable));
    }

    private final void constructMod() {
        Object object;
        try {
            LoggerKt.getLOGGER().trace(LogMarkers.LOADING, "Loading mod instance " + this.getModId() + " of type " + this.modClass.getName());
            Object obj = JvmClassMappingKt.getKotlinClass(this.modClass).getObjectInstance();
            if (obj == null) {
                object = this.modClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNullExpressionValue(object, "modClass.getDeclaredConstructor().newInstance()");
                obj = object;
            }
            this.modInstance = obj;
            LoggerKt.getLOGGER().trace(LogMarkers.LOADING, "Loaded mod instance " + this.getModId() + " of type " + this.modClass.getName());
        }
        catch (Throwable throwable) {
            LoggerKt.getLOGGER().error(LogMarkers.LOADING, "Failed to create mod instance. ModID: " + this.getModId() + ", class " + this.modClass.getName(), throwable);
            Object[] objectArray = new Object[]{this.modClass};
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", throwable, objectArray);
        }
        try {
            LoggerKt.getLOGGER().trace(LogMarkers.LOADING, "Injecting Automatic Kotlin event subscribers for " + this.getModId());
            ClassLoader throwable = this.modClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue(throwable, "modClass.classLoader");
            AutoKotlinEventBusSubscriber.INSTANCE.inject(this, this.scanResults, throwable);
            LoggerKt.getLOGGER().trace(LogMarkers.LOADING, "Completed Automatic Kotlin event subscribers for " + this.getModId());
        }
        catch (Throwable throwable) {
            LoggerKt.getLOGGER().error(LogMarkers.LOADING, "Failed to register Automatic Kotlin subscribers. ModID: " + this.getModId() + ", class " + this.modClass.getName(), throwable);
            object = new Object[]{this.modClass};
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", throwable, object);
        }
    }

    public boolean matches(@Nullable Object mod) {
        Object object = this.modInstance;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException("modInstance");
            object = Unit.INSTANCE;
        }
        return Intrinsics.areEqual(mod, object);
    }

    @NotNull
    public Object getMod() {
        Object object = this.modInstance;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException("modInstance");
            object = Unit.INSTANCE;
        }
        return object;
    }

    public <T extends Event> void acceptEvent(@NotNull T e) {
        Intrinsics.checkNotNullParameter(e, "e");
        try {
            LoggerKt.getLOGGER().debug("Firing event for modid " + this.modId + " : " + e);
            this.eventBus.post(e);
            LoggerKt.getLOGGER().debug("Fired event for modid " + this.modId + " : " + e);
        }
        catch (Throwable t) {
            LoggerKt.getLOGGER().error("Caught exception during event " + e + " dispatch for modid " + this.modId, t);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", t, new Object[0]);
        }
    }

    private static final void _init_$lambda-0(KotlinModContainer this$0, IConfigEvent event) {
        Intrinsics.checkNotNullParameter((Object)this$0, "this$0");
        this$0.eventBus.post(event.self());
    }
}

