/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;

public class ClaimedChunk
implements ClaimResult {
    public FTBChunksTeamData teamData;
    public final ChunkDimPos pos;
    public long time;
    public long forceLoaded;

    public ClaimedChunk(FTBChunksTeamData p, ChunkDimPos cp) {
        this.teamData = p;
        this.pos = cp;
        this.time = System.currentTimeMillis();
        this.forceLoaded = 0L;
    }

    public FTBChunksTeamData getTeamData() {
        return this.teamData;
    }

    public ChunkDimPos getPos() {
        return this.pos;
    }

    public long getTimeClaimed() {
        return this.time;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public void setClaimedTime(long t) {
        this.time = t;
        this.teamData.manager.updateForceLoadedChunks();
        this.sendUpdateToAll();
    }

    public long getForceLoadedTime() {
        return this.forceLoaded;
    }

    public boolean isForceLoaded() {
        return this.forceLoaded > 0L;
    }

    public boolean isActuallyForceLoaded() {
        return this.isForceLoaded() && this.teamData.canForceLoadChunks();
    }

    @Override
    public void setForceLoadedTime(long time) {
        this.forceLoaded = time;
        this.teamData.manager.updateForceLoadedChunks();
        this.sendUpdateToAll();
        ServerLevel level = this.teamData.manager.getMinecraftServer().m_129880_(this.pos.dimension);
        if (level != null) {
            if (this.forceLoaded > 0L) {
                level.m_6325_(this.pos.x, this.pos.z);
            }
            ServerChunkCache cache = level.m_7726_();
            ChunkPos chunkPos = this.pos.getChunkPos();
            if (cache != null) {
                if (this.forceLoaded > 0L) {
                    cache.m_8387_(FTBChunksAPI.FORCE_LOADED_TICKET, chunkPos, 2, (Object)chunkPos);
                } else {
                    cache.m_8438_(FTBChunksAPI.FORCE_LOADED_TICKET, chunkPos, 2, (Object)chunkPos);
                }
            } else {
                FTBChunks.LOGGER.warn("Failed to force-load chunk " + this.pos.x + ", " + this.pos.z + " @ " + this.pos.dimension.m_135782_() + "!");
            }
        }
    }

    public boolean canEntitySpawn(Entity entity) {
        return true;
    }

    public boolean allowExplosions() {
        return false;
    }

    public void sendUpdateToAll() {
        SendChunkPacket packet = new SendChunkPacket();
        packet.dimension = this.pos.dimension;
        packet.teamId = this.teamData.getTeamId();
        packet.chunk = new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, this);
        packet.sendToAll(this.teamData.manager.getMinecraftServer());
    }

    public void unload(CommandSourceStack source) {
        if (this.isForceLoaded()) {
            this.setForceLoadedTime(0L);
            ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNLOAD.invoker()).after(source, this);
            this.teamData.save();
        }
    }

    public void unclaim(CommandSourceStack source, boolean sync) {
        this.unload(source);
        this.teamData.manager.claimedChunks.remove(this.pos);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNCLAIM.invoker()).after(source, this);
        this.teamData.save();
        if (sync) {
            SendChunkPacket packet = new SendChunkPacket();
            packet.dimension = this.pos.dimension;
            packet.teamId = Util.f_137441_;
            packet.chunk = new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, null);
            packet.sendToAll(source.m_81377_());
        }
    }
}

