/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import shadows.hostilenetworks.HostileClient;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.client.WrappedRTBuffer;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.DataModel;

public class DataModelItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final MultiBufferSource.BufferSource GHOST_ENTITY_BUF = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
    private static final ResourceLocation DATA_MODEL_BASE = new ResourceLocation("hostilenetworks", "item/data_model_base");
    private static final WeakHashMap<ItemStack, CachedModel> CACHE = new WeakHashMap();

    public DataModelItemStackRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType type, PoseStack matrix, MultiBufferSource buf, int light, int overlay) {
        LivingEntity ent;
        CachedModel model = CACHE.computeIfAbsent(stack, s -> new CachedModel((ItemStack)s, 0));
        ItemRenderer irenderer = Minecraft.m_91087_().m_91291_();
        BakedModel base = irenderer.m_115103_().m_109393_().getModel(DATA_MODEL_BASE);
        matrix.m_85836_();
        if (type == ItemTransforms.TransformType.FIXED) {
            matrix.m_85837_(1.0, 1.0, 0.0);
            scale = 0.5f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85837_(-1.5, -0.5, 0.5);
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrix.m_85837_(0.0, 0.0, -1.0);
        } else if (type != ItemTransforms.TransformType.GUI) {
            matrix.m_85837_(1.0, 1.0, 0.0);
            scale = 0.5f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85837_(-1.5, -0.5, 0.5);
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        } else {
            matrix.m_85837_(0.0, -0.5, -0.5);
            matrix.m_85845_(Vector3f.f_122222_.m_122240_(75.0f));
            matrix.m_85845_(Vector3f.f_122227_.m_122240_(45.0f));
            scale = 0.9f;
            matrix.m_85841_(scale, scale, scale);
            matrix.m_85837_(0.775, 0.0, -0.0825);
        }
        irenderer.m_115189_(base, stack, light, overlay, matrix, ItemRenderer.m_115222_((MultiBufferSource)GHOST_ENTITY_BUF, (RenderType)ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true), (boolean)true, (boolean)false));
        GHOST_ENTITY_BUF.m_109911_();
        matrix.m_85849_();
        if (model.getModel() != null && (ent = model.getEntity((Level)Minecraft.m_91087_().f_91073_)) != null) {
            this.renderEntityInInventory(matrix, type, ent, model.getModel());
        }
    }

    public void renderEntityInInventory(PoseStack matrix, ItemTransforms.TransformType type, LivingEntity pLivingEntity, DataModel model) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        if (type == ItemTransforms.TransformType.FIXED) {
            matrix.m_85837_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.m_85841_(scale *= model.getScale(), scale, scale);
            matrix.m_85837_(0.0, 1.45, 0.0);
            matrix.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
            matrix.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
        } else if (type == ItemTransforms.TransformType.GUI) {
            matrix.m_85837_(0.0, -0.5, 0.0);
            scale = 0.4f;
            matrix.m_85841_(scale *= model.getScale(), scale, scale);
            matrix.m_85837_(0.0, 0.45, 0.0);
        } else {
            scale = 0.25f;
            matrix.m_85841_(scale *= model.getScale(), scale, scale);
            matrix.m_85837_(0.0, 0.12 + 0.05 * Math.sin(((float)HostileClient.clientTicks + Minecraft.m_91087_().m_91297_()) / 12.0f), 0.0);
        }
        float rotation = -30.0f;
        if (type == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || type == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND) {
            rotation = 30.0f;
        }
        if (type == ItemTransforms.TransformType.FIXED) {
            rotation = 180.0f;
        }
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        pLivingEntity.m_146922_(0.0f);
        pLivingEntity.f_20883_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20885_ = pLivingEntity.m_146908_();
        pLivingEntity.f_20886_ = pLivingEntity.m_146908_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource rtBuffer = GHOST_ENTITY_BUF;
        WeirdRenderThings.fullbright_tesr = true;
        WeirdRenderThings.translucent = true;
        RenderSystem.m_69890_(() -> entityrenderermanager.m_114384_((Entity)pLivingEntity, (double)model.getXOffset(), (double)model.getYOffset(), (double)model.getZOffset(), 0.0f, 1.0f, matrix, (MultiBufferSource)new WrappedRTBuffer((MultiBufferSource)rtBuffer), 0xF000F0));
        rtBuffer.m_109911_();
        WeirdRenderThings.translucent = false;
        WeirdRenderThings.fullbright_tesr = false;
        entityrenderermanager.m_114468_(true);
        matrix.m_85849_();
    }
}

